// $Id: ompdcc.java,v 1.5 2000/12/20 06:16:55 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $

package ompd;

import exc.object.*;
import exc.openmp.*;
import exc.flow.*;

public class ompdcc extends exc.util.ccDriver {
  public ompdcc(){ super("ompd"); }
  
  public ompdcc(String name){ super(name); }

  public static void main(String args[]){ 
    ompdcc driver = new ompdcc();
    driver.run(args);
  }
  
  public boolean parseArg(String arg){
    if(arg.equals("--no-opt")){
      OMPDtransform.optFlag = false;
      System.out.println("optimize off ...");
      return true;
    } 
    return false;
  }

  public void init(){
    cpp_opts += " -DOMPC -D_OPENMP";
    cpp_opts += " "+getTemplateValue("OMPC_CFLAGS");

    if(getTemplateValue("CFRONT_FLAGS") != null)
      cfront_opts += " "+getTemplateValue("CFRONT_FLAGS");

    ld_opts += " "+getTemplateValue("OMPC_MAIN");
    ld_opts += " "+getTemplateValue("OMPC_LDFLAGS");
  }

  public void run(XobjectFile f){
    if(verbose) System.err.println("transformation pass ... "+
				   f.getSourceFileName());
    f.debugFlag = debugFlag;
    SSAtransform.debugFlag = debugFlag;
    OMPDtransform.debugFlag = debugFlag;


    OMP.setMoveAutoFlag(true);
    
    OMPtranslateBlock op = new OMPtranslateBlock();
    op.init(f,false);
    f.iterateDef(op);   // transform OMP pragma
    if(OMP.errorFlag){
      System.err.println("error in OpenMP. stop.");
      System.exit(1);
    }

    OMPDtransform opOMPD = new OMPDtransform();
    f.iterateFuncDef(opOMPD);

    op.init(f,true);
    f.iterateDef(op);   // transform OMP pragma
  }
}




