// $Id: sample2.java,v 1.4 1999/05/20 09:33:20 m-hirano Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
import java.io.*;
import exc.object.*;

// sample2:
// 	rewrite VAR_ADDR/LVAR_ADDR/PARAM_ADDR -> VAR/LVAR/PARAM_VAR
//
public class sample2 implements XobjectDefVisitor {

  public void doDef(XobjectDef d){
    Xobject s;
    XobjectIterator i = new bottomupXobjectIterator(d.getDef());
    for(i.init(); !i.end(); i.next()){
      Xobject x = i.getXobject();
      if(x == null) continue;
      switch(x.Opcode()){
      case Xcode.VAR_ADDR:
	s = Xcons.Symbol(Xcode.VAR,x.Type(), x.getSym());
	i.setXobject(Xcons.List(Xcode.ADDR_OF,Xtype.Pointer(x.Type()),s));
	break;
      case Xcode.LVAR_ADDR:
	s = Xcons.Symbol(Xcode.LVAR,x.Type(), x.getSym());
	i.setXobject(Xcons.List(Xcode.ADDR_OF,Xtype.Pointer(x.Type()),s));
	break;
      case Xcode.PARAM_ADDR:
	s = Xcons.Symbol(Xcode.PARAM_VAR,x.Type(), x.getSym());
	i.setXobject(Xcons.List(Xcode.ADDR_OF,Xtype.Pointer(x.Type()),s));
	break;
      case Xcode.POINTER_REF:
	if(x.left().Opcode() == Xcode.ADDR_OF)
	  i.setXobject(x.left().left());
      }
    }
    d.setDef(i.topXobject());
  }

  //
  // main program of this phase
  //
  public static void main(String args[]){
    String infile = null;
    String outfile = null;
    
    if(args.length >= 1) infile = args[0];
    if(args.length >= 2) outfile = args[1];
    System.out.println("infile="+infile+",outfile="+outfile);
    XobjectFile f = new XobjectFile(infile,outfile);
    sample2 op = new sample2();

    f.Input();
    f.iterateFuncDef(op);
    f.Output();
    f.Decompile();
  }
}
