// $Id: sample3.java,v 1.2 1999/05/20 09:33:21 m-hirano Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
import java.io.*;
import exc.object.*;

// sample3:
// 	print Variable names in Function
//
class sample3 /* PrintVarRef */ implements XobjectDefVisitor {

  public void doDef(XobjectDef d){
    String fname = d.getName();
    XobjectIterator i = new topdownXobjectIterator(d.getFuncBody());
    for(i.init();!i.end(); i.next()){
      Xobject x = i.getXobject();
      if(x == null) continue;
      if(x.isVariable() || x.isVarAddr())
	System.out.println("Variable '"+x.getName()+
			   "' is referenced from Function '"+fname+"'");
    }
  }

  public static void main(String args[]){
    String infile = null;
    String outfile = null;
    
    if(args.length >= 1) infile = args[0];
    if(args.length >= 2) outfile = args[1];
    System.out.println("infile="+infile+",outfile="+outfile);
    XobjectFile f = new XobjectFile(infile,outfile);

    sample3 op = new sample3();

    f.Input();
    f.iterateFuncDef(op);
  }
}
