// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
package st;

import exc.object.*;
import exc.block.*;
import exc.flow.*;
import java.util.*;

public class ControlFlowGraphSt
{
  ControlFlowGraph cfg;

  public ControlFlowGraphSt(BlockList body){
    BlockIterator i = new topdownBlockIterator(body);
    for(i.init(); !i.end(); i.next()){
      Block b = i.getBlock();
      if(b.Opcode() == Xcode.FOR_STATEMENT) {
	if(b.getPrev() == null || b.getPrev().Opcode() != Xcode.LIST)
	  b.insert(Bcons.emptyBlock());
	if(b.getNext() == null || b.getNext().Opcode() == Xcode.LIST)
	  b.add(Bcons.emptyBlock());
      } else if (b.Opcode() == Xcode.IF_STATEMENT) {
        if (b.getElseBody() == null) {
          b.setElseBody(new BlockList(Bcons.emptyBlock()));
        } else if (b.getElseBody().isEmpty()) {
          b.getElseBody().add(Bcons.emptyBlock());
        }
      }
    }
    cfg = new ControlFlowGraph(body);
  }
  public ControlFlowGraph get() { return cfg;}
}
