#include "exc_platform.h"

float
#ifdef KR_headers
etime_(tarray) float *tarray;
#else
etime_(float *tarray)
#endif
{
    struct rusage ru;
    int stat = getrusage(RUSAGE_SELF, &ru);

    if (stat != 0) {
	return -1.0;
    }

    tarray[0] = (float)(ru.ru_utime.tv_sec + (float)(ru.ru_utime.tv_usec / 1000000.0));
    tarray[1] = (float)(ru.ru_stime.tv_sec + (float)(ru.ru_stime.tv_usec / 1000000.0));

    return tarray[0] + tarray[1];
}

