static char rcsid[] = "$Id: omniIoSub.c,v 1.1 2000/03/22 23:52:24 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include <stdio.h>
#include "f2c.h"
#include "lio.h"
#include "fio.h"

extern VOID	sig_die _ANSI_ARGS_((char *s, int kill));
    
static char *
__allocIt(str, len)
     char *str;
     int len;
{
    char *ret = (char *)malloc(sizeof(char) * (len + 1));
    if (ret == NULL) {
	sig_die("Can't allocate memory.", 1);
    }
    memcpy(ret, str, len);
    ret[len] = '\0';
    return ret;
}


int
_IO_Open(unitPtr, fname, fnameLen, status, statusLen, access, accessLen, form, formLen,
	 reclPtr, blank, blankLen, errFlag)
     int *unitPtr;
     char *fname;
     int fnameLen;
     char *status;
     int statusLen;
     char *access;
     int accessLen;
     char *form;
     int formLen;
     int *reclPtr;
     char *blank;
     int blankLen;
     int errFlag;
{
    olist ol;
    int ret = 1;
    memset(&ol, 0, sizeof(olist));

    ol.oerr = (flag)errFlag;
    ol.ounit = (ftnint)*unitPtr;
    if (fname == NULL ||
	fname[0] == '\0') {
	ol.ofnm = NULL;
    } else {
	ol.ofnm = __allocIt(fname, fnameLen);
    }
    ol.ofnmlen = (ftnlen)fnameLen;
    ol.osta = __allocIt(status, statusLen);
    ol.oacc = __allocIt(access, accessLen);
    if (form != NULL &&
	form[0] != '\0') {
	ol.ofm = __allocIt(form, formLen);
    } else {
	if (strcasecmp(ol.oacc, "DIRECT") == 0) {
	    ol.ofm = __allocIt("UNFORMATTED", strlen("UNFORMATTED"));
	} else {
	    ol.ofm = __allocIt("FORMATTED", strlen("FORMATTED"));
	}
    }
    ol.orl = (ftnint)*reclPtr;
    if (strcasecmp(ol.oacc, "DIRECT") == 0) {
	if (ol.orl <= 0) {
	    sig_die("invalid record length.", 1);
	}
    }
    ol.oblnk = __allocIt(blank, blankLen);

    ret = f_open(&ol);

    if (ol.ofnm != NULL) {
	(void)free(ol.ofnm);
    }
    (void)free(ol.osta);
    (void)free(ol.oacc);
    (void)free(ol.ofm);
    (void)free(ol.oblnk);

    return ret;
}


int
_IO_Close(unitPtr, status, statusLen, errFlag)
     int *unitPtr;
     char *status;
     int statusLen;
     int errFlag;
{
    cllist cl;
    int ret = 1;
    memset(&cl, 0, sizeof(cllist));

    cl.cerr = (flag)errFlag;
    cl.cunit = (ftnint)*unitPtr;
    cl.csta = __allocIt(status, statusLen);

    ret = f_clos(&cl);

    (void)free(cl.csta);

    return ret;
}


int
_IO_Backspace(unitPtr, errFlag)
     int *unitPtr;
     int errFlag;
{
    alist al;

    al.aerr = (flag)errFlag;
    al.aunit = (ftnint)*unitPtr;

    return f_back(&al);
}


int
_IO_Rewind(unitPtr, errFlag)
     int *unitPtr;
     int errFlag;
{
    alist al;

    al.aerr = (flag)errFlag;
    al.aunit = (ftnint)*unitPtr;

    return f_rew(&al);
}


int
_IO_Endfile(unitPtr, errFlag)
     int *unitPtr;
     int errFlag;
{
    alist al;

    al.aerr = (flag)errFlag;
    al.aunit = (ftnint)*unitPtr;

    return f_end(&al);
}


int
_IO_Inquire(unitPtr, filePtr, fileLen,
	    existPtr,
	    openedPtr,
	    numberPtr,
	    namedPtr,
	    namePtr, nameLen,
	    accessPtr, accessLen,
	    sequentialPtr, sequentialLen,
	    directPtr, directLen,
	    formPtr, formLen,
	    formattedPtr, formattedLen,
	    unformattedPtr, unformattedLen,
	    reclPtr,
	    nextrecPtr,
	    blankPtr, blankLen,
	    errFlag)
     int *unitPtr;
     char *filePtr; int fileLen;
     int *existPtr;
     int *openedPtr;
     int *numberPtr;
     int *namedPtr;
     char *namePtr; int nameLen;
     char *accessPtr; int accessLen;
     char *sequentialPtr; int sequentialLen;
     char *directPtr; int directLen;
     char *formPtr; int formLen;
     char *formattedPtr; int formattedLen;
     char *unformattedPtr; int unformattedLen;
     int *reclPtr;
     int *nextrecPtr;
     char *blankPtr; int blankLen;
     int errFlag;
{
    inlist il;

    il.inerr = errFlag;

    if (unitPtr != NULL) {
	il.inunit = (ftnint)*unitPtr;
    } else {
	il.inunit = (ftnint)0;
    }
    il.infile = filePtr;
    il.infilen = (ftnlen)fileLen;
    il.inex = (ftnint *)existPtr;
    il.inopen = (ftnint *)openedPtr;
    il.innum = (ftnint *)numberPtr;
    il.innamed = (ftnint *)namedPtr;
    il.inname = namePtr;
    il.innamlen = (ftnlen)nameLen;
    il.inacc = accessPtr;
    il.inacclen = (ftnlen)accessLen;
    il.inseq = sequentialPtr;
    il.inseqlen = (ftnlen)sequentialLen;
    il.indir = directPtr;
    il.indirlen = (ftnlen)directLen;
    il.infmt = formPtr;
    il.infmtlen = (ftnlen)formLen;
    il.inform = formattedPtr;
    il.informlen = (ftnlen)formattedLen;
    il.inunf = unformattedPtr;
    il.inunflen = (ftnlen)unformattedLen;
    il.inrecl = (ftnint *)reclPtr;
    il.innrec = (ftnint *)nextrecPtr;
    il.inblank = blankPtr;
    il.inblanklen = (ftnlen)blankLen;

    return f_inqu(&il);
}
