static char rcsid[] = "$Id: ogr_call.c,v 1.2 2001/12/21 03:06:22 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "exc_platform.h"
#include "ns.h"
#include "nsapi.h"
#include "nsclient.h"
#include "opengr.h"

int __rpc_atLeastOneCall = 0;
void
__rpcSync EXC_VARARGS_DEF(char *, stubname)
{
    va_list args;
    int sid;
    nsapi_exec_info_t *inf = NULL;

    EXC_VARARGS_START(char *, stubname, args);
    sid = nscli_call(stubname, &args, NSDEF_TRUE);
    if (sid < NSDEF_OK) {
	fprintf(stderr, "OpenGR runtime: RPC failed.\n");
	exit(1);
    }
    va_end(args);

    inf = NS_get_info(sid);
    if (inf == NULL) {
	fprintf(stderr, "OpenGR runtime: RPC failed.\n");
	exit(1);
    }
}


void
__rpcAsync EXC_VARARGS_DEF(char *, stubname)
{
    va_list args;

    EXC_VARARGS_START(char *, stubname, args);
    (void)nscli_call(stubname, &args, NSDEF_FALSE);
    va_end(args);
    __rpc_atLeastOneCall++;
}


void
__rpcWait()
{
    if (__rpc_atLeastOneCall > 0) {
	(void)NS_wait_all();
	__rpc_atLeastOneCall = 0;
    }
}

