static char rcsid[] = "$Id: ogr_main.c,v 1.1 2001/12/18 08:05:41 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include "exc_platform.h"
#include "ns.h"
#include "nsapi.h"

int __ogr_enable = 1;
extern int __rpc_atLeastOneCall;

extern int _ompc_main (int argc, char *argv[]);
extern void _ompc_init(int argc, char *argv[]);
extern void _ompc_terminate (int);


static void	__ogr_exit_handler(void);

static void
__ogr_exit_handler()
{
    if (__rpc_atLeastOneCall > 0) {
	(void)NS_wait_all();
    }
}


int
main(int argc, char *argv[])
{
    int status;
    char *ogrDisableEnv = getenv("OGR_DISABLE");

    __rpc_atLeastOneCall = 0;

    if (ogrDisableEnv != NULL) {
	if (strcasecmp(ogrDisableEnv, "1") == 0 ||
	    strcasecmp(ogrDisableEnv, "Yes") == 0 ||
	    strcasecmp(ogrDisableEnv, "True") == 0) {
	    __ogr_enable = 0;
	}
    }
    if (__ogr_enable == 1) {
	int newArgc = 0;
	if ((newArgc = NS_parse_arg(argc, argv)) == NSDEF_NG) {
	    fprintf(stderr, "OpenGR runtime: parsing arguments failed.\n");
	    return 1;
	}
	argc = newArgc;
    }

    _ompc_init(argc, argv);

    if (__ogr_enable == 1) {
	(void)atexit(__ogr_exit_handler);
    }
    status = _ompc_main(argc, argv);
    _ompc_terminate(status);

    return 0;
}

