/*
 * replace <asm/atomic.h>
 * because PGI compiler can not compile "/usr/include/asm/atomic.h" of kernel header file. :<
 */

typedef struct { volatile int counter; } atomic_t;

#define atomic_set(v,i)		(((v)->counter) = (i))
#define atomic_read(v)		((v)->counter)

static void atomic_inc(atomic_t *);
static void atomic_dec(atomic_t *);


static void
__func_atomic_inc ()
{
  asm(" 	.align 4				");
  asm("		.type	 atomic_inc,@function		");
  asm("atomic_inc:					");
  asm("		pushl	%ebp				");
  asm("		movl	%esp, %ebp			");
  asm("		movl	8(%ebp), %eax			");
  asm("		lock ; incl (%eax)			");
  asm("		popl	%ebp				");
  asm("		ret					");
  asm(".Lfe3:						");
  asm("		.size	 atomic_inc,.Lfe3-atomic_inc	");
}

static void
__func_atomic_dec ()
{
  asm("		.align 4				");
  asm("		.type	 atomic_dec,@function		");
  asm("atomic_dec:					");
  asm("		pushl	%ebp				");
  asm("		movl	%esp, %ebp			");
  asm("		movl	8(%ebp), %eax			");
  asm("		lock ; decl (%eax)			");
  asm("		popl	%ebp				");
  asm("		ret					");
  asm(".Lfe4:						");
  asm("		.size	 atomic_dec,.Lfe4-atomic_dec	");
}

