static char rcsid[] = "$Id: timer.c,v 1.1 2000/04/18 09:54:11 msato Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* timer functions */

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

/* #define USE_GETRUSAGE */

double second()
{
    double t;
#ifdef USE_GETRUSAGE
    struct rusage ru;
 
    getrusage(RUSAGE_SELF, &ru);
    t = (double)(ru.ru_utime.tv_sec+ru.ru_stime.tv_sec) + 
      ((double)(ru.ru_utime.tv_usec+ru.ru_stime.tv_usec))/1.0e6 ;
    return t ;
#else
    struct timeval tv;
    gettimeofday(&tv, NULL);
    t = (double)(tv.tv_sec) + ((double)(tv.tv_usec))/1.0e6;
    return t ;
#endif
}

static double start_time;

double start_timer()
{
    start_time = second();
    return start_time;
}

double lap_time(char *msg)
{
    double t;
    t = second();
    if (msg)
	printf("%s %g\n", msg, t-start_time);
    return t;
}

