static char rcsid[] = "$Id: ompc_lib.c,v 1.4 2000/07/19 12:37:16 y-tanaka Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include <stdlib.h>
#include "ompclib.h"
#include "omp.h"

/*
 * OMP standard library function
 */
extern struct ompc_thread *_ompc_current_thread();
extern _ompc_lock_t _ompc_proc_lock,_ompc_thread_lock;
extern volatile int _ompc_num_threads;

int omp_get_thread_num()
{
    struct ompc_thread *tp;
    tp = _ompc_current_thread();
    ST_POLLING();
    return tp->num;
}

int omp_get_thread_num_() { return omp_get_thread_num(); }

int omp_get_num_threads()
{
    struct ompc_thread *tp;
    struct ompc_parent *tpp;
    tp = _ompc_current_thread();
    ST_POLLING();
    if((tpp = tp->parent) == NULL)
      return 1;
    else 
      return tpp->num_thds;
}

int omp_get_num_threads_() { return omp_get_num_threads(); }

void omp_set_num_threads(int num)
{
    struct ompc_thread *tp;
    if(num <= 0){
	printf("omp_set_num_threads: argument must be positive.");
	_ompc_fatal("ompc_set_num_threads");
    }
    tp = _ompc_current_thread();
    ST_POLLING();
    if( tp->num != 0 )
	return;
    if ( _ompc_max_threads < num ){
	printf("set fail: %d exceeds max parallel number %d\n", num, _ompc_max_threads);
	_ompc_fatal("ompc_set_num_threads");
    }
    /* printf(" -set a number of parallelism [%d]\n", num); */
    _ompc_lock(&_ompc_proc_lock);
    _ompc_num_threads = num;
    _ompc_unlock(&_ompc_proc_lock);
}

void omp_set_num_threads_(int *num) {  omp_set_num_threads(*num); }

int omp_get_max_threads()
{
    ST_POLLING();
    return _ompc_num_threads;
}

int omp_get_max_threads_() { return omp_get_max_threads(); }

int omp_get_num_procs()
{
    ST_POLLING();
    return _ompc_n_proc;
}

int omp_get_num_procs_() { return omp_get_num_procs(); }

int omp_in_parallel()
{
    struct ompc_thread *tp;
    tp = _ompc_current_thread();
    ST_POLLING();
    return tp->parent != NULL;
}

int omp_in_parallel_() { return omp_in_parallel(); }

void omp_set_dynamic(int dynamic_thds)
{
    ST_POLLING();
    _ompc_dynamic = dynamic_thds;
}

void omp_set_dynamic_(int *dynamic_thds){ omp_set_dynamic(*dynamic_thds); }

int omp_get_dynamic()
{
    ST_POLLING();
    return 0 /*_ompc_dynamic*/; /* not implmented */
}

int omp_get_dynamic_() { return omp_get_dynamic(); }

void omp_set_nested(int n_nested)
{
    ST_POLLING();
    _ompc_nested = n_nested;
}

void omp_set_nested_(int *n_nested){ omp_set_nested(*n_nested); }

int omp_get_nested()
{
    ST_POLLING();
    return _ompc_nested; 
}

int omp_get_nested_() { return omp_get_nested(); }

/*
 * Lock Functions
 */
void omp_init_lock(omp_lock_t *lock)
{
    _ompc_lock_t *lp;
    _ompc_lock(&_ompc_thread_lock);
    if((lp = (_ompc_lock_t *)malloc(sizeof(_ompc_lock_t))) == NULL)
	_ompc_fatal("cannot allocate lock memory");
    _ompc_init_lock(lp);
    _ompc_unlock(&_ompc_thread_lock);
    *lock = (omp_lock_t)lp;
    ST_POLLING();
}

void omp_init_lock_(_omf77Lock_t *lock) { omp_init_lock((omp_lock_t *)lock); }


void omp_init_nest_lock(omp_nest_lock_t *lock)
{
    _ompc_nest_lock_t *lp;

    _ompc_lock (&_ompc_thread_lock);
    if ((lp = (_ompc_nest_lock_t *)malloc(sizeof(_ompc_nest_lock_t))) == NULL)
        _ompc_fatal("cannot allocate lock memory");
    _ompc_init_nest_lock (lp);
    _ompc_unlock(&_ompc_thread_lock);
    *lock = (omp_nest_lock_t)lp;
    ST_POLLING();
}

void omp_init_nest_lock_(_omf77Lock_t *lock) { omp_init_nest_lock((omp_nest_lock_t *)lock); }


void omp_destroy_lock(omp_lock_t *lock)
{
    _ompc_destroy_lock((_ompc_lock_t *)*lock);
    _ompc_lock(&_ompc_thread_lock);
    free((_ompc_lock_t *)*lock);
    _ompc_unlock(&_ompc_thread_lock);
    ST_POLLING();
}

void omp_destroy_lock_(_omf77Lock_t *lock) { omp_destroy_lock((omp_lock_t *)lock); }


void omp_destroy_nest_lock(omp_nest_lock_t *lock)
{
    _ompc_destroy_nest_lock((_ompc_nest_lock_t *)*lock);
    _ompc_lock(&_ompc_thread_lock);
    free((_ompc_nest_lock_t *)*lock);
    _ompc_unlock(&_ompc_thread_lock);
    ST_POLLING();
}

void omp_destroy_nest_lock_(_omf77Lock_t *lock) { omp_destroy_nest_lock((omp_nest_lock_t *)lock); }


void omp_set_lock(omp_lock_t *lock)
{
    ST_POLLING();
    _ompc_lock((_ompc_lock_t *)*lock);
}

void omp_set_lock_(_omf77Lock_t *lock) { omp_set_lock((omp_lock_t *)lock); }


void omp_set_nest_lock(omp_nest_lock_t *lock)
{
    ST_POLLING();
    _ompc_nest_lock((_ompc_nest_lock_t *)*lock);
}

void omp_set_nest_lock_(_omf77Lock_t *lock) { omp_set_nest_lock((omp_nest_lock_t *)lock); }


void omp_unset_lock(omp_lock_t *lock)
{
    ST_POLLING();
    _ompc_unlock((_ompc_lock_t *)*lock);
}

void omp_unset_lock_(_omf77Lock_t *lock) { omp_unset_lock((omp_lock_t *)lock); }


void omp_unset_nest_lock(omp_nest_lock_t *lock)
{
    ST_POLLING();
    _ompc_nest_unlock((_ompc_nest_lock_t *)*lock);
}

void omp_unset_nest_lock_(_omf77Lock_t *lock) { omp_unset_nest_lock((omp_nest_lock_t *)lock); }


int omp_test_lock(omp_lock_t *lock)
{
    ST_POLLING();
    return _ompc_test_lock((_ompc_lock_t *)*lock);
}

int omp_test_lock_(_omf77Lock_t *lock) { return omp_test_lock((omp_lock_t *)lock); }


int omp_test_nest_lock(omp_nest_lock_t *lock)
{
    ST_POLLING();
    return _ompc_test_nest_lock((_ompc_nest_lock_t *)*lock);
}

int omp_test_nest_lock_(_omf77Lock_t *lock) { return omp_test_nest_lock((omp_nest_lock_t *)lock); }
