static char rcsid[] = "$Id: ompc_main.c,v 1.6 2001/07/24 16:14:40 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include "exc_platform.h"
#include "ompclib.h"

extern int _ompc_main (int argc, char *argv[]);
extern void _ompc_init(int argc, char *argv[]);
extern void _ompc_terminate(int);
extern void *become_worker_group(worker_group_conf_t wgc,
				 int nw,
				 worker_proc_t f,
				 void *a0, void *a1,
				 void *a2, void *a3);

void* _ompc_main_wrap(void *argc_, void *argv_, void *x, void *y)
{
    int argc = (int)argc_;
    char **argv = (char **)argv_;
    int r;
    char *st_profile = getenv("ST_PROFILE");
    if (st_profile) {
	st_begin_profile();
    }
    r = _ompc_main(argc, argv);
    if (st_profile) {
	st_end_profile();
    }
    return (void *)r;
}

int main(int argc, char **argv)
{
    int status, nw;

    ST_CALLBACK_BEGIN();
    _ompc_init(argc, argv);
    nw = _ompc_n_proc;
    stf_sgc_init(nw);
    {
	/* set configuration of the toplevel worker group
	   according to the command line options */
	struct worker_group_conf c[1];
	stf_init_worker_group_conf(c);
	stf_worker_group_conf_set_prof_filename(c, "00stprof");
	status = (int)become_worker_group
	    (c, nw,
	     (worker_proc_t)_ompc_main_wrap, 
	     (void *)argc, (void *)argv, 
	     NULL, NULL);
    }    
    stf_sgc_finalize();
    ST_CALLBACK_END();
    _ompc_terminate (status);
      /* exit(status); */
    return 0;
}

int st_main() { return 0;}
