static char rcsid[] = "$Id: prlfor008.c,v 1.8 2002/06/22 18:09:05 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel for 008:
 * check implicit barrier at end of parallel for section.
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	*buf;


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


void clear()
{
  int	i;

  for (i=0; i<thds; i++) {
    buf[i] = -1;
  }
}

main ()
{
  int	lp, finish;

  int	errors = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  buf = (int *) malloc (sizeof (int) * thds);
  if (buf == NULL) {
    printf ("can not allocate memory.\n");
    exit (1);
  }
  omp_set_dynamic (0);

  finish = 0;
  clear ();
  #pragma omp parallel for schedule (static,1)
  for (lp=0; lp<thds; lp++) {
    int	id = omp_get_thread_num ();

    /* make barrier, and thread 1-x delay any sec from thread 0 */
    if (id == 0) {
      finish = 1;
    } else {
      while (finish == 0) {
        #pragma omp flush
      }
      waittime (1);
    }
    buf[id] = omp_get_thread_num ();
    #pragma omp flush
  }

  for (lp=0; lp<thds; lp++) {
    if (buf[lp] == -1) {
      errors += 1;
    }
  }


  finish = 0;
  clear ();
  #pragma omp parallel for schedule (dynamic,1)
  for (lp=0; lp<thds; lp++) {
    int	id = omp_get_thread_num ();

    barrier (thds);

    /* make barrier, and thread 1-x delay any sec from thread 0 */
    if (omp_get_thread_num () == 0) {
      finish = 1;
    } else {
      while (finish == 0) {
        #pragma omp flush
      }
      waittime (1);
    }
    buf[id] = omp_get_thread_num ();
    #pragma omp flush
  }

  for (lp=0; lp<thds; lp++) {
    if (buf[lp] == -1) {
      errors += 1;
    }
  }



  clear ();
  #pragma omp parallel for schedule (guided,1)
  for (lp=0; lp<thds*4; lp++) {
    int	id = omp_get_thread_num ();

    /* make barrier, and thread 1-x delay any sec from thread 0 */

    buf[id] = -2;
    #pragma omp flush

    if (id != 0) {
      waittime (1);
    }

    buf[id] = id;
    #pragma omp flush
  }

  for (lp=0; lp<thds; lp++) {
    if (buf[lp] == -2) {
      errors += 1;
    }
  }


  if (errors == 0) {
    printf ("parallel for 008 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel for 008 : FAILED\n");
    return 1;
  }
}
