static char rcsid[] = "$Id: prlfor010.c,v 1.7 2000/10/13 19:26:50 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel for structure 010:
 * data attribute ꤵ줿ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	errors = 0;

int	shrd;
int	prvt, fprvt, lprvt, tprvt;
int	rdct, ordd;

#pragma omp threadprivate (tprvt)


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


main ()
{
  int	i;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  prvt = fprvt = tprvt = shrd = -1;
  rdct = ordd = 0;
  #pragma omp parallel for private(prvt) firstprivate(fprvt) lastprivate(lprvt) \
	                   reduction(+:rdct) ordered schedule(static,1) \
		           default(none) shared(thds,shrd,errors,ordd) copyin(tprvt)
  for (i=0; i<thds; i++) {
    int id = omp_get_thread_num ();

    if (omp_in_parallel() == 0) {
      #pragma omp critical
      errors += 1;
    }
    if (omp_get_num_threads() != thds) {
      #pragma omp critical
      errors += 1;
    }
    if (omp_get_thread_num() >= thds) {
      #pragma omp critical
      errors += 1;
    }

    if (fprvt != -1) {
      #pragma omp critical
      errors += 1;
    }

    if (tprvt != -1) {
      #pragma omp critical
      errors += 1;
    }

    if (shrd != -1) {
      #pragma omp critical
      errors += 1;
    }

    barrier (thds);

    prvt = id;
    fprvt = id;
    lprvt = i;
    rdct += 1;
    tprvt = id;
    shrd = id;

    barrier (thds);

    if (prvt != id) {
      #pragma omp critical
      errors += 1;
    }
    if (fprvt != id) {
      #pragma omp critical
      errors += 1;
    }
    if (lprvt != i) {
      #pragma omp critical
      errors += 1;
    }
    if (tprvt != id) {
      #pragma omp critical
      errors += 1;
    }
    if (shrd != i) {
      #pragma omp critical
      errors += 1;
    }


    #pragma omp ordered
    {
      if (i != ordd) {
	errors += 1;
      }
      ordd += 1;
    }
  }

  if (lprvt != thds-1) {
    errors += 1;
  }

  if (rdct != thds) {
    errors += 1;
  }

  if (errors == thds-1) {
    printf ("parallel for 010 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel for 010 : FAILED\n");
    return 1;
  }
}
