static char rcsid[] = "$Id: prlsctn007.c,v 1.7 2000/10/13 19:26:55 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel sections 007:
 * parallel sections if Ωʤưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds, ids[2];
int	errors = 0;


int
sameas(int n)
{
  return n;
}


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


void
check_parallel ()
{
  if (omp_in_parallel () == 0) {
    #pragma omp critical
    errors += 1;
  }
  if (omp_get_num_threads () == 1) {
    #pragma omp critical
    errors += 1;
  }
}


void
check ()
{
  if (ids[0] == ids[1]) {
    errors += 1;
  }
}


main ()
{
  int	 true = 2;
  double dtrue = 3.0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel sections if (1)
  {
    #pragma omp section
    {	
      check_parallel ();
      ids[0] = omp_get_thread_num ();
      barrier (2);
    }
    #pragma omp section
    {	
      check_parallel ();
      ids[1] = omp_get_thread_num ();
      barrier (2);
    }
  }
  check();

  #pragma omp parallel sections if (true)
  {
    #pragma omp section
    {	
      check_parallel ();
      ids[0] = omp_get_thread_num ();
      barrier (2);
    }
    #pragma omp section
    {	
      check_parallel ();
      ids[1] = omp_get_thread_num ();
      barrier (2);
    }
  }
  check();

  #pragma omp parallel sections if (dtrue)
  {
    #pragma omp section
    {	
      check_parallel ();
      ids[0] = omp_get_thread_num ();
      barrier (2);
    }
    #pragma omp section
    {	
      check_parallel ();
      ids[1] = omp_get_thread_num ();
      barrier (2);
    }
  }
  check();

  #pragma omp parallel sections if (true == 2)
  {
    #pragma omp section
    {	
      check_parallel ();
      ids[0] = omp_get_thread_num ();
      barrier (2);
    }
    #pragma omp section
    {	
      check_parallel ();
      ids[1] = omp_get_thread_num ();
      barrier (2);
    }
  }
  check();

  #pragma omp parallel sections if (sameas(true))
  {
    #pragma omp section
    {	
      check_parallel ();
      ids[0] = omp_get_thread_num ();
      barrier (2);
    }
    #pragma omp section
    {	
      check_parallel ();
      ids[1] = omp_get_thread_num ();
      barrier (2);
    }
  }
  check();


  if (errors == 0) {
    printf ("parallel sections 007 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel sections 007 : FAILED\n");
    return 1;
  }
}
