static char rcsid[] = "$Id: attr001.c,v 1.3 2000/07/30 13:09:02 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* attribute 001 :
 * parallel region ѿ defualt  shared ˤʤǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;

int	shrd0;


func (int *shrd1)
{
  #pragma omp critical
  {
    shrd0  += 1;
    *shrd1 += 1;
  }
}


main ()
{
  int	shrd1;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);

  shrd0 = 0;
  shrd1 = 0;

  #pragma omp parallel
  {
    #pragma omp critical
    {
      shrd0 += 1;
      shrd1 += 1;
    }
  }

  if (shrd0 != thds  ||  shrd1 != thds) {
    errors ++;
  }


  shrd0 = 0;
  shrd1 = 0;

  #pragma omp parallel
  func (&shrd1);

  if (shrd0 != thds  ||  shrd1 != thds) {
    errors ++;
  }

  if (errors == 0) {
    printf ("attribute 001 : SUCCESS\n");
    return 0;
  } else {
    printf ("attribute 001 : FAILED\n");
    return 1;
  }
}
