static char rcsid[] = "$Id: attr004.c,v 1.4 2000/07/30 13:09:03 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* attribute 004 :
 * parallel region  heap ΰ shared ˤʤǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;


void
func ()
{
  static int	*heap;


  #pragma omp single
  {
    heap = (int *) malloc (sizeof(int));
    *heap = 0;
  }

  #pragma omp critical
  *heap += 1;

  #pragma omp barrier
  if (*heap != thds) {
    #pragma omp critical
    errors += 1;
  }
}


int
main ()
{

  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel
  {
    static int	*heap;

    #pragma omp single
    {
      heap = (int *) malloc (sizeof (int));	
      if (heap == NULL) {
	printf ("can not allocate memory.\n");
      }
      *heap = 0;
    }

    #pragma omp critical
    *heap += 1;

    #pragma omp barrier
    if (*heap != thds) {
      #pragma omp critical
      errors += 1;
    }
  }

  #pragma omp parallel
  func();

  if (errors == 0) {
    printf ("attribute 004 : SUCCESS\n");
    return 0;
  } else {
    printf ("attribute 004 : FAILED\n");
    return 1;
  }
}
