static char rcsid[] = "$Id: dflt005.c,v 1.3 2000/07/30 13:09:08 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* default 005 :
 * default(none)Ƥơdata attributeƤưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define	MAGICNO	100


int	errors = 0;
int	thds;

int	tprvt, prvt, fprvt, lprvt, rdct, shrd;
#pragma omp threadprivate (tprvt)


const int	cnst = MAGICNO;


main ()
{
  int	i, r;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);

  rdct = shrd = 0;
  fprvt = MAGICNO;
  #pragma omp parallel for default(none) private (prvt) firstprivate(fprvt) lastprivate(lprvt) reduction(+:rdct) shared(shrd,thds,errors) schedule (static,1)
  for (i=0; i<thds; i++) {
    #pragma omp critical
    {
      shrd  += 6*i;		      /* shrd is shared, i is private */
    }
    tprvt  = i;			      /* tprvt is threadprivate */
    prvt   = 2*i;		      /* prvt is private */
    fprvt += 3*i;		      /* fprvt is firstprivate */
    lprvt  = 4*i;		      /* lprvt is lastprivate */
    rdct  += 5*i;		      /* rdct is reduction(+) */
    waittime (1);

    if (prvt != 2*i) {		      /* check private */
      #pragma omp critical
      errors += 1;
    }
    if (fprvt != MAGICNO + 3*i) {
      #pragma omp critical
      errors += 1;
    }
  }

  r = 0;
  for (i=0; i<thds; i++) 
    r += i;
  if (rdct != r * 5) {
    errors += 1;
  }

  if (shrd != r * 6) {
    errors += 1;
  }

  if (lprvt != 4*(thds-1)) {
    errors += 1;
  }

  #pragma omp parallel for default(shared) schedule (static)
  for (i=0; i<thds; i++) {
    if (tprvt != i) {
      #pragma omp critical
      errors += 1;
    }
  }


  if (errors == 0) {
    printf ("default 005 : SUCCESS\n");
    return 0;
  } else {
    printf ("default 005 : FAILED\n");
    return 1;
  }
}
