static char rcsid[] = "$Id: dflt007.c,v 1.3 2000/07/30 13:09:08 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* default 007 :
 * default  prallel for ꤷưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define	MAGICNO	100


int	errors = 0;
int	thds;

int	shrd;


main ()
{
  int	i;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  shrd = 0;
  #pragma omp parallel for default (shared) schedule(static)
  for (i=0; i<thds; i++) {
    #pragma omp critical
    shrd += 1;
  }
  if (shrd != thds) {
    errors += 1;
  }


  shrd = 0;
  #pragma omp parallel for default (none) shared(shrd,thds) schedule(static)
  for (i=0; i<thds; i++) {
    #pragma omp critical
    shrd += 1;
  }
  if (shrd != thds) {
    errors += 1;
  }


  if (errors == 0) {
    printf ("default 007 : SUCCESS\n");
    return 0;
  } else {
    printf ("default 007 : FAILED\n");
    return 1;
  }
}
