static char rcsid[] = "$Id: err_firstprivate_001.c,v 1.2 2000/06/30 09:45:16 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* error case of firstprivate 001 :
 * private ѿfirstprivate 뤳ȤϽʤ
 */

#include "omniConfig.h"
#include <omp.h>


#define	MAGICNO		100

int	errors = 0;
int	thds;


int	prvt;


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel private(prvt)
  {
    int	id = omp_get_thread_num ();
    int	i;

    prvt = MAGICNO;
    #pragma omp for firstprivate(prvt)
    for (i=0; i<thds; i++) {
      prvt += id;
      sleep (1);
      if (prvt != MAGICNO + id) {
	errors += 1;
      }
    }
  }
  printf ("err_firstprivate 001 : FAILED, can not compile this program.\n");
  return 1;
}
