static char rcsid[] = "$Id: fstprvt002.c,v 1.3 2000/07/30 13:09:11 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* firstprivate 002 :
 * ѿФ firstprivate ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define MAGICNO		100

int	errors = 0;
int	thds;



void
func1 (int magicno, int *prvt, int *prvt2)
{
  int	id = omp_get_thread_num ();

  if (*prvt != magicno) {
    #pragma omp critical
    errors += 1;
  }
  if (*prvt2 != magicno+1) {
    #pragma omp critical
    errors += 1;
  }

  *prvt  = id;
  *prvt2 = id+magicno;

  #pragma omp barrier
  if (*prvt != id) {
    #pragma omp critical
    errors += 1;
  }
  #pragma omp barrier
  if (*prvt2 != id+magicno) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{
  int		prvt;
  static int	prvt2;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  prvt  = MAGICNO;
  prvt2 = MAGICNO + 1;
  #pragma omp parallel firstprivate (prvt) firstprivate(prvt2)
  {
    int	id = omp_get_thread_num ();

    if (prvt != MAGICNO) {
      #pragma omp critical
      errors += 1;
    }
    if (prvt2 != MAGICNO+1) {
      #pragma omp critical
      errors += 1;
    }

    prvt = id;
    prvt2 = id+MAGICNO;

    #pragma omp barrier
    if (prvt != id) {
      #pragma omp critical
      errors += 1;
    }
    #pragma omp barrier
    if (prvt2 != id+MAGICNO) {
      #pragma omp critical
      errors += 1;
    }
  }


  prvt  = MAGICNO*2;
  prvt2 = MAGICNO*2+1;
  #pragma omp parallel firstprivate (prvt) firstprivate(prvt2)
  func1 (MAGICNO*2, &prvt, &prvt2);


  if (errors == 0) {
    printf ("firstprivate 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("firstprivate 002 : FAILED\n");
    return 1;
  }
}
