static char rcsid[] = "$Id: fstprvt015.c,v 1.3 2000/07/30 13:09:11 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* firstprivate 015 :
 * enumѿФ firstprivate ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"

#define MAGICNO		100

int	errors = 0;
int	thds;


enum x {
  ZERO = 0,
  ONE,
  TWO,
  THREE
};

enum x	prvt;


void
func1 (int magicno, enum x *prvt)
{
  int	id = omp_get_thread_num ();


  if (*prvt != (enum x)magicno) {
    #pragma omp critical
    errors += 1;
  }

  *prvt = (enum x)id;
  #pragma omp barrier

  if (*prvt != (enum x)id) {
    #pragma omp critical
    errors += 1;
  }
  if (sizeof(*prvt) != sizeof(enum x)) {
    #pragma omp critical
    errors += 1;
  }
}


void
func2 (int magicno)
{
  static int err;
  int	id = omp_get_thread_num ();


  if (prvt != (enum x)magicno) {
    #pragma omp critical
    errors += 1;
  }

  #pragma omp barrier
  prvt = (enum x)id;
  err  = 0;

  #pragma omp barrier
  if (prvt != (enum x)id) {
    #pragma omp critical
    err += 1;
  }
  #pragma omp barrier
  #pragma omp master
  if (err != thds - 1) {
    #pragma omp critical
    errors ++;
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  prvt = (enum x)MAGICNO;
  #pragma omp parallel firstprivate (prvt)
  {
    int	id = omp_get_thread_num ();

    if (prvt != (enum x)MAGICNO) {
      #pragma omp critical
      errors += 1;
    }

    prvt = (enum x)id;

    #pragma omp barrier
    if (prvt != (enum x)id) {
      #pragma omp critical
      errors += 1;
    }
    if (sizeof(prvt) != sizeof(enum x)) {
      #pragma omp critical
      errors += 1;
    }
  }


  prvt = (enum x)(MAGICNO*2);
  #pragma omp parallel firstprivate (prvt)
  func1 (MAGICNO*2, &prvt);


  prvt = (enum x)(MAGICNO*3);
  #pragma omp parallel firstprivate (prvt)
  func2 (MAGICNO*3);


  if (errors == 0) {
    printf ("firstprivate 015 : SUCCESS\n");
    return 0;
  } else {
    printf ("firstprivate 015 : FAILED\n");
    return 1;
  }
}
