static char rcsid[] = "$Id: rdctn003.c,v 1.3 2000/07/30 13:09:24 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* reduction 003 :
 * reduction(-:...) ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define	LOOPNUM	(thds * 2)

int	errors = 0;
int	thds;

int	rdct_dec, rdct_dec2, rdct_mns, rdct_mns2;


void
func_reduction (int loop)
{
  int	i;

  #pragma omp for reduction(-:rdct_dec,rdct_dec2,rdct_mns,rdct_mns2)
  for (i=0; i<loop; i++) {
    rdct_dec --;
    -- rdct_dec2;
    rdct_mns -= i*2;
    rdct_mns2 = rdct_mns2 - i*3;
  }
}


void
check (int init, int loop)
{
  int	rst_dec, rst_dec2, rst_mns, rst_mns2;
  int	i;


  rst_dec = rst_dec2 = rst_mns = rst_mns2 = init;
  for (i=0;  i<loop;  i++) {
    rst_dec --;
    -- rst_dec2;
    rst_mns -= i*2;
    rst_mns2 = rst_mns2 - i*3;
  }

  if (rst_dec != rdct_dec) {
    errors += 1;
  }

  if (rst_dec2 != rdct_dec2) {
    errors += 1;
  }

  if (rst_mns != rdct_mns) {
    errors += 1;
  }

  if (rst_mns2 != rdct_mns2) {
    errors += 1;
  }
}


main ()
{
  int	i;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  rdct_dec = rdct_dec2 = rdct_mns = rdct_mns2 = 0;
  #pragma omp parallel
  {
    #pragma omp for reduction(-:rdct_dec,rdct_dec2,rdct_mns,rdct_mns2) 
    for (i=0; i<LOOPNUM; i++) {
      rdct_dec --;
      -- rdct_dec2;
      rdct_mns -= i*2;
      rdct_mns2 = rdct_mns2 - i*3;
    }
  }
  check (0, LOOPNUM);


  rdct_dec = rdct_dec2 = rdct_mns = rdct_mns2 = 100;
  #pragma omp parallel
  func_reduction (LOOPNUM);
  check (100, LOOPNUM);


  rdct_dec = rdct_dec2  = rdct_mns = rdct_mns2 = 200;
  func_reduction (LOOPNUM);
  check (200, LOOPNUM);


  if (errors == 0) {
    printf ("reduction 003 : SUCCESS\n");
    return 0;
  } else {
    printf ("reduction 003 : FAILED\n");
    return 1;
  }
}
