static char rcsid[] = "$Id: rdctn007.c,v 1.3 2000/07/30 13:09:24 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* reduction 007 :
 * reduction(^:...) ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define	LOOPNUM	(thds * 2)

int	errors = 0;
int	thds;

int	rdct_xor, rdct_xor2, rdct_xor3;


void
func_reduction (int loop)
{
  int	i;

  #pragma omp for reduction(^:rdct_xor,rdct_xor2,rdct_xor3)
  for (i=0; i<loop; i++) {
    rdct_xor ^= (1<<i);
    rdct_xor2 = rdct_xor2 ^ ((1<<(i*2))| 2);
    rdct_xor3 = ((1<<(i*3)) | 3) ^ rdct_xor3;
  }
}


void
check (int init, int loop)
{
  int	rst_xor, rst_xor2, rst_xor3;
  int	i;


  rst_xor = rst_xor2 = rst_xor3 = init;
  for (i=0;  i<loop;  i++) {
    rst_xor ^= (1<<i);
    rst_xor2 = rst_xor2 ^ ((1<<(i*2))| 2);
    rst_xor3 = ((1<<(i*3)) | 3) ^ rst_xor3;
  }

  if (rst_xor != rdct_xor) {
    errors += 1;
  }

  if (rst_xor2 != rdct_xor2) {
    errors += 1;
  }

  if (rst_xor3 != rdct_xor3) {
    errors += 1;
  }
}


main ()
{
  int	i;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  rdct_xor = rdct_xor2 = rdct_xor3 = 0;
  #pragma omp parallel
  {
    #pragma omp for reduction(^:rdct_xor,rdct_xor2,rdct_xor3)
    for (i=0; i<LOOPNUM; i++) {
      rdct_xor ^= (1<<i);
      rdct_xor2 = rdct_xor2 ^ ((1<<(i*2))| 2);
      rdct_xor3 = ((1<<(i*3)) | 3) ^ rdct_xor3;
    }
  }
  check (0, LOOPNUM);

  rdct_xor = rdct_xor2 = rdct_xor3 = 1<<8;
  #pragma omp parallel
  {
    #pragma omp for reduction(^:rdct_xor,rdct_xor2,rdct_xor3)
    for (i=0; i<LOOPNUM; i++) {
      rdct_xor ^= (1<<i);
      rdct_xor2 = rdct_xor2 ^ ((1<<(i*2))| 2);
      rdct_xor3 = ((1<<(i*3)) | 3) ^ rdct_xor3;
    }
  }
  check (1<<8, LOOPNUM);

  rdct_xor = rdct_xor2 = rdct_xor3 = 1<<16;
  #pragma omp parallel
  func_reduction (LOOPNUM);
  check (1<<16, LOOPNUM);

  rdct_xor = rdct_xor2 = rdct_xor3 = 1<<24;
  func_reduction (LOOPNUM);
  check (1<<24, LOOPNUM);


  if (errors == 0) {
    printf ("reduction 007 : SUCCESS\n");
    return 0;
  } else {
    printf ("reduction 007 : FAILED\n");
    return 1;
  }
}
