static char rcsid[] = "$Id: shrd002.c,v 1.3 2000/07/30 13:09:27 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* shared 002 :
 * localѿФ롢shared ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;


void
func1 (int *shrd)
{
  #pragma omp critical
  *shrd += 1;
  #pragma omp barrier

  if (*shrd != thds) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{
  int		shrd;
  static int	shrd2;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  shrd = 0;
  #pragma omp parallel shared(shrd)
  {
    #pragma omp critical
    shrd += 1;

    #pragma omp barrier

    if (shrd != thds) {
      #pragma omp critical
      errors += 1;
    }
  }


  shrd2 = 0;
  #pragma omp parallel shared(shrd2)
  {
    #pragma omp critical
    shrd2 += 1;

    #pragma omp barrier

    if (shrd2 != thds) {
      #pragma omp critical
      errors += 1;
    }
  }


  shrd = 0;
  #pragma omp parallel shared(shrd)
  func1 (&shrd);


  shrd2 = 0;
  #pragma omp parallel shared(shrd2)
  func1 (&shrd2);


  if (errors == 0) {
    printf ("shared 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("shared 002 : FAILED\n");
    return 1;
  }
}
