static char rcsid[] = "$Id: thdprvt003.c,v 1.4 2000/10/13 19:27:07 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* threadprivate 003 :
 * nested parallel regionΥޥåƱΤǡ
 * threadprivate åΩƤǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;

int	i;
#pragma omp threadprivate (i)


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


void
func (int id, int n)
{
  i = id;
  barrier (n);

  if (i != id) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{

  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);
  omp_set_nested(0);


  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();

    #pragma omp parallel
    {
      i = id;
      barrier (thds);

      if (i != id) {
	#pragma omp critical
	errors += 1;
      }
    }
  }

  #pragma omp parallel 
  {
    int	id = omp_get_thread_num ();

    #pragma omp parallel
    {
      func (id, thds);
    }
  }

  func(0,1);


  if (errors == 0) {
    printf ("threadprivate 003 : SUCCESS\n");
    return 0;
  } else {
    printf ("threadprivate 003 : FAILED\n");
    return 1;
  }
}
