static char rcsid[] = "$Id: thdprvt024.c,v 1.3 2000/07/30 13:09:31 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* threadprivate 024 :
 * threadprivateѿꤷưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define ARRAYSIZ	1024


int	errors = 0;
int	thds;

int	i[ARRAYSIZ];
#pragma omp threadprivate (i)


void
clear ()
{
  int	j;

  for (j=0; j<ARRAYSIZ; j++) {
    i[j] = j + ARRAYSIZ;
  }
}

void
func ()
{
  int	j;
  int	id = omp_get_thread_num ();

  for (j=0; j<ARRAYSIZ; j++) {
    if (i[j] != j + ARRAYSIZ) {
      #pragma omp critical
      errors += 1;
    }
  }
  for (j=0; j<ARRAYSIZ; j++) {
    i[j] = id + j;
  }
  #pragma omp barrier
  
  for (j=0; j<ARRAYSIZ; j++) {
    if (i[j] != id + j) {
      #pragma omp critical
      errors += 1;
    }
  }
  if (sizeof(i) != sizeof(int) * ARRAYSIZ) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{

  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);

  clear ();
  #pragma omp parallel copyin(i)
  {
    int j;
    int	id = omp_get_thread_num ();

    for (j=0; j<ARRAYSIZ; j++) {
      if (i[j] != j + ARRAYSIZ) {
        #pragma omp critical
	errors += 1;
      }
    }
    for (j=0; j<ARRAYSIZ; j++) {
      i[j] = id + j;
    }
    #pragma omp barrier
  
    for (j=0; j<ARRAYSIZ; j++) {
      if (i[j] != id + j) {
        #pragma omp critical
	errors += 1;
      }
    }
    if (sizeof(i) != sizeof(int) * ARRAYSIZ) {
      #pragma omp critical
      errors += 1;
    }
  }

  clear ();
  #pragma omp parallel copyin(i)
  func ();

  clear ();
  func ();


  if (errors == 0) {
    printf ("threadprivate 024 : SUCCESS\n");
    return 0;
  } else {
    printf ("threadprivate 024 : FAILED\n");
    return 1;
  }
}
