static char rcsid[] = "$Id: nest002.c,v 1.5 2002/06/22 18:09:05 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* netsting 002 :
 * check nested parallel region at nested parallel is enabled.
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;


int	sum;


void
func_nesting ()
{
  #pragma omp parallel
  {
    int	add;

    if (omp_get_num_threads () == 1) {
      add = 2;
      printf ("nested parallel is serialized.\n");
    } else {
      add = 1;
    }

    #pragma omp critical
    {
      sum += add;
    }
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);
  omp_set_num_threads (2);
  omp_set_nested (1);
  if (omp_get_nested () == 0) {
    printf ("test skipped.\n");
    exit(0);
  }

  sum = 0;
  #pragma omp parallel
  {
    #pragma omp parallel
    {
      int	add;

      if (omp_get_num_threads () == 1) {
	add = 2;
	printf ("nested parallel is serialized.\n");
      } else {
	add = 1;
      }

      #pragma omp critical
      {
	sum += add;
      }
    }
  }
  if (sum != 2*2) {	
    errors += 1;
  }


  sum = 0;
  #pragma omp parallel
  func_nesting ();
  if (sum != 2*2) {	
    errors += 1;
  }


  if (errors == 0) {
    printf ("nesting 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("nesting 002 : FAILED\n");
    return 1;
  }
}
