static char rcsid[] = "$Id: nest003.c,v 1.3 2000/07/30 13:09:34 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* netsting 003 :
 * for,sections,single  parallel binding ǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;
int	sum_for, sum_sct, sum_sngl;


void
func ()
{
  int		i;

  #pragma omp for 
  for (i=0; i<thds; i++) {
    #pragma omp critical
    sum_for += 1;
  }

  #pragma omp sections
  {
    #pragma omp section
    {
      #pragma omp critical
      sum_sct += 1;
    }
    #pragma omp section
    {
      #pragma omp critical
      sum_sct += 1;
    }
    #pragma omp section
    {
      #pragma omp critical
      sum_sct += 1;
    }
  }

  #pragma omp single
  {
    #pragma omp critical
    {
      sum_sngl += 1;
    }
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  sum_for = 0;
  sum_sct = 0;
  sum_sngl = 0;

  #pragma omp parallel
  {
    int		i;

    #pragma omp for 
    for (i=0; i<thds; i++) {
      #pragma omp critical
      sum_for += 1;
    }

    #pragma omp sections
    {
      #pragma omp section
      {
	#pragma omp critical
	sum_sct += 1;
      }
      #pragma omp section
      {
	#pragma omp critical
	sum_sct += 1;
      }
      #pragma omp section
      {
	#pragma omp critical
	sum_sct += 1;
      }
    }

    #pragma omp single
    {
      #pragma omp critical
      {
	sum_sngl += 1;
      }
    }
  }

  if (sum_for != thds) {
    errors += 1;
  }
  if (sum_sct != 3) {
    errors += 1;
  }
  if (sum_sngl != 1) {
    errors += 1;
  }


  sum_for = 0;
  sum_sct = 0;
  sum_sngl = 0;

  #pragma omp parallel
  func ();

  if (sum_for != thds) {
    errors += 1;
  }
  if (sum_sct != 3) {
    errors += 1;
  }
  if (sum_sngl != 1) {
    errors += 1;
  }


  if (errors == 0) {
    printf ("nesting 003 : SUCCESS\n");
    return 0;
  } else {
    printf ("nesting 003 : FAILED\n");
    return 1;
  }
}
