static char rcsid[] = "$Id: parallel002.c,v 1.6 2000/07/30 13:09:37 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel structure 002:
 * parallel if Ωưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	errors = 0;


int sameas(int v)
{
  return v;
}


void
check_parallel (int v)
{
  int	tn;

  if (omp_in_parallel () != v) {
    #pragma omp critical
    errors += 1;
  }

  if (v == 0) {
    tn = 1;
  } else {
    tn = thds;
  }
  if (omp_get_num_threads () != tn) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{
  double dtrue = 2.0;
  int	 true = 3;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  check_parallel (0);		      /* not parallel */

  #pragma omp parallel if (1)
  check_parallel (1);		      /* here is parallel */

  check_parallel (0);		      /* not parallel */

  #pragma omp parallel if (dtrue)
  {				      /* this block is parallel */
    check_parallel(1);
  }

  check_parallel (0);		      /* not parallel */

  #pragma omp parallel if (true == 3)
  if (true) {			      /* this if-block is parallel */
    check_parallel (1);
  }

  check_parallel (0);		      /* not parallel */

  #pragma omp parallel if (sameas(4))
  if (true) {			      /* this if-block is parallel */
    check_parallel (1);
  }

  if (errors == 0) {
    printf ("parallel 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel 002 : FAILED\n");
    return 1;
  }
}
