static char rcsid[] = "$Id: parallel005.c,v 1.7 2002/06/22 18:09:06 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel structure 005:
 * check implicit barrier at end of parallel region
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


main ()
{
  int	thds;

  int	errors = 0;
  int	v = 0;
  int	finish = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel
  {
    int id = omp_get_thread_num ();

    if (id == 0) {
      finish = 1;
      #pragma omp flush
    } else {
      while (finish == 0) {
	#pragma omp flush
      }
      waittime (1);
      v = 1;
    }
  } /* implicit barrier exist, here */

  if (v == 0) {
    errors = 1;
  }
  

  if (errors == 0) {
    printf ("parallel 005 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel 005 : FAILED\n");
    return 1;
  }
}
