static char rcsid[] = "$Id: parallel008.c,v 1.6 2002/10/08 13:44:38 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* parallel structure 008:
 * when outside nested parallel region is serialized,
 * inside nested parallel region is serialized at 
 * nested parallel region is disabled.
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	errors = 0;

int	true = 1;
int	false = 0;


void
check_parallel (int thds)
{
  if(thds == 0) {
    if (omp_in_parallel () != 0) {
      #pragma omp critical
      {
	ERROR (errors);
      }
    }
    if (omp_get_num_threads () != 1) {
      #pragma omp critical
      {
	ERROR (errors);
      }
    }

  } else {
    if (omp_in_parallel () == 0) {
      #pragma omp critical
      {
	ERROR (errors);
      }
    }
    if (omp_get_num_threads () != thds) {
      #pragma omp critical
      {
printf("%d, %d\n", thds, omp_get_num_threads());
	ERROR (errors);
      }
    }
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);
  omp_set_nested(0);


  #pragma omp parallel if (false)
  {
    /* here is not parallel */
    check_parallel (0);

    #pragma omp parallel
    {
      /* this nested parallel is serialized */
      check_parallel (1);
    }
  }


  if (errors == 0) {
    printf ("parallel 008 : SUCCESS\n");
    return 0;
  } else {
    printf ("parallel 008 : FAILED\n");
    return 1;
  }
}
