static char rcsid[] = "$Id: atomic009.c,v 1.4 2000/10/13 19:27:09 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* atomic 009:
 * floatѿФ롢atomic ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#define LOOPNUM		(thds * 2)

int		errors = 0;
int		thds;
float		atom_incr, atom_incr2, atom_decr, atom_decr2;
float		atom_plus, atom_mul, atom_minus, atom_div;


int
sameas (int v)
{
  return v;
}


void
clear ()
{
  atom_incr = 0;
  atom_incr2 = 0;
  atom_decr = 0;
  atom_decr2 = 0;

  atom_plus = 0;
  atom_minus = 0;
  atom_mul = 1;
  atom_div = 1;
}


int
check ()
{
  int	i;
  float	tmp;

  int	err = 0;


  if (atom_incr != LOOPNUM) {
    err ++;
  }
  if (atom_incr2 != LOOPNUM) {
    err ++;
  }
  if (atom_decr != -LOOPNUM) {
    err ++;
  }
  if (atom_decr2 != -LOOPNUM) {
    err ++;
  }

  if (atom_plus != LOOPNUM) {
    err ++;
  }
  if (atom_minus != -LOOPNUM) {
    err ++;
  }

  for (i=0, tmp=1; i<LOOPNUM; i++) {
    tmp = tmp * 2;
  }
  if (atom_mul != tmp) {
    err ++;
  }

  for (i=0, tmp=1; i<LOOPNUM; i++) {
    tmp = tmp / 2;
  }
  if (atom_div != tmp) {
    err ++;
  }

  return err;
}


main ()
{
  int	i;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  if (4 < thds) {
    thds = 4;
    omp_set_num_threads (4);
  }

  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    #pragma omp for 
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic
      atom_incr ++;
    }

    #pragma omp for 
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic
      ++ atom_incr2;
    }

    #pragma omp for 
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic
      atom_decr --;
    }

    #pragma omp for
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic
      -- atom_decr2;
    }

    #pragma omp for
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic	
      atom_plus += sameas(2) - 1;
    }

    #pragma omp for
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic	
      atom_minus -= sameas(2) - 1;
    }

    #pragma omp for
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic	
      atom_mul *= sameas(3) - 1;
    }

    #pragma omp for
    for (i=0; i<LOOPNUM; i++) {
      #pragma omp atomic	
      atom_div /= 4 + sameas(-2);
    }
  }
  errors += check ();

  if (errors == 0) {
    printf ("atomic 009 : SUCCESS\n");
    return 0;
  } else {
    printf ("atomic 009 : FAILED\n");
    return 1;
  }
}
