static char rcsid[] = "$Id: crtcl002.c,v 1.3 2000/07/30 13:09:59 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* critical 002:
 * ۤcritical֤Ǥ¾γǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	errors = 0;

int	data;


void
clear ()
{
  data = 0;
}


int
read_data ()
{
  return data;
}


void
write_data (int d)
{
  data = d;
}


void
check (int n)
{
  if (4<n) {
    n = 4;
  }

  if (data != n) {
    errors += 1;
  }
}


void
func_critical ()
{
  int	id = omp_get_thread_num ();
  int	i;


  #pragma omp barrier

  switch (id) {
  case 0:
    #pragma omp critical
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 1:
    #pragma omp critical
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 2:
    #pragma omp critical
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 3:
    #pragma omp critical
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  default:
    break;
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();
    int	i;

    #pragma omp barrier

    switch (id) {
    case 0:
      #pragma omp critical
      {
	i = read_data ();
	waittime (1);
	write_data (i+1);
      }
      break;
    case 1:
      #pragma omp critical
      {
	i = read_data ();
	waittime (1);
	write_data (i+1);
      }
      break;
    case 2:
      #pragma omp critical
      {
        i = read_data ();
        waittime (1);
        write_data (i+1);
      }
      break;
    case 3:
      #pragma omp critical
      {
        i = read_data ();
        waittime (1);
        write_data (i+1);
      }
      break;
    default:
      break;
    }
  }
  check (thds);

  clear ();
  #pragma omp parallel
  func_critical ();
  check (thds);


  clear ();
  func_critical ();
  check (1);


  if (errors == 0) {
    printf ("critical 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("critical 002 : FAILED\n");
    return 1;
  }
}
