static char rcsid[] = "$Id: flush004.c,v 1.4 2002/06/22 16:38:50 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* flush 004:
 * check implicit flush at end of barrier
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;

int	a, b;


void
clear ()
{
  a = 0;
  b = 0;
}


void
func_flush ()
{
  a = 0;
  #pragma omp barrier

  if (omp_get_thread_num () == 0) {
    waittime (1);
    a = 1;
    #pragma omp barrier
  } else {
    #pragma omp barrier
    if (a == 0) {
      #pragma omp critical
      errors += 1;
    }
  }

  #pragma omp barrier
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    a = 0;
    #pragma omp barrier

    if (omp_get_thread_num () == 0) {
      waittime (1);
      a = 1;
      #pragma omp barrier
    } else {
      #pragma omp barrier
      if (a == 0) {
	#pragma omp critical
	errors += 1;
      }
    }

    #pragma omp barrier
  }


  clear ();
  #pragma omp parallel
  func_flush ();


  if (errors == 0) {
    printf ("flush 004 : SUCCESS\n");
    return 0;
  } else {
    printf ("flush 004 : FAILED\n");
    return 1;
  }
}
