static char rcsid[] = "$Id: flush007.c,v 1.4 2002/06/22 16:38:50 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* flush 007:
 * check implicit flush at end of parallel region
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;

int	a, b;


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);
  omp_set_num_threads (2);


  #pragma omp parallel
  {
    a = 0;
    b = 0;
    #pragma omp barrier
    if (omp_get_thread_num () == 0) {
      a = 1;
    } else {
      b = 1;
    }
  }
  if (a != 1  ||  b != 1) {
    errors ++;
  }

  #pragma omp parallel
  {
    if (omp_get_thread_num () == 0) {
      a = 0;
    } else {
      b = 0;
    }
  }
  if (a != 0  ||  b != 0) {
    errors ++;
  }


  if (errors == 0) {
    printf ("flush 007 : SUCCESS\n");
    return 0;
  } else {
    printf ("flush 007 : FAILED\n");
    return 1;
  }
}
