static char rcsid[] = "$Id: flush009.c,v 1.4 2000/10/13 19:27:12 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* flush 009:
 * sectionsλΰۤflushǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;
int	thds;



void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


main ()
{
  int	a, b;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel 
  {
    #pragma omp sections 
    {
      #pragma omp section
      {
	b = 0;
	barrier (2);
	#pragma omp flush (a,b)

	a = 1;
      }

      #pragma omp section
      {
	a = 0;
	barrier (2);
	#pragma omp flush (a,b)

	b = 1;
      }
    }
    if (a != 1  ||  b != 1) {
      errors ++;
    }
  }


  if (errors == 0) {
    printf ("flush 009 : SUCCESS\n");
    return 0;
  } else {
    printf ("flush 009 : FAILED\n");
    return 1;
  }
}
