static char rcsid[] = "$Id: flush017.c,v 1.3 2000/07/30 13:10:02 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* flush 017:
 * longѿФflush ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"

int	errors = 0;
int	thds;

long	a;


void
clear ()
{
  a = 0;
}


void
func_flush ()
{
  int	id = omp_get_thread_num ();

  switch (id) {
  case 0:
    waittime (1);
    a = -1;
    #pragma omp flush
    while (a == -1) {
      #pragma omp flush
    }
    break;

  case 1:
    while (a == 0) {
      #pragma omp flush
    }
    a = 0;
    #pragma omp flush
    break;

  default:
    break;
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();

    switch (id) {
    case 0:
      waittime (1);
      a = 1;
      #pragma omp flush
      while (a == 1) {
        #pragma omp flush
      }
      break;

    case 1:
      while (a == 0) {
        #pragma omp flush
      }
      a = 0;
      #pragma omp flush
      break;

    default:
      break;
    }
  }
  clear ();

  #pragma omp parallel
  func_flush ();
  clear ();


  if (errors == 0) {
    printf ("flush 017 : SUCCESS\n");
    return 0;
  } else {
    printf ("flush 017 : FAILED\n");
    return 1;
  }
}
