static char rcsid[] = "$Id: ordrd005.c,v 1.5 2002/04/03 10:38:33 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* ordered 005:
 * strideѹưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifdef __OMNI_SCASH__
#define LOOPNUM		(thds*10)
#else
#define LOOPNUM		(thds*100)
#endif



int	errors = 0;
int	thds;
int	cnt;


void
clear ()
{
  cnt = 0;
}


void
func_ordered (int i, int s)
{
  #pragma omp ordered
  {
    if (cnt != i) {
      #pragma omp critical
      errors ++;
    }
    cnt += s;
  }
}


main ()
{
  int	i,stride;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);

  for (stride=1; stride<10; stride++) {
    clear ();
    #pragma omp parallel for ordered
    for (i=0;  i<LOOPNUM;  i+=stride) {
      func_ordered (i, stride);
    }
  }


  if (errors == 0) {
    printf ("ordered 005 : SUCCESS\n");
    return 0;
  } else {
    printf ("ordered 005 : FAILED\n");
    return 1;
  }
}
