static char rcsid[] = "$Id: sctn001.c,v 1.4 2000/07/30 13:10:14 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* sections 001:
 * sections directiveưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	buf[3];

int	errors = 0;


void
clear ()
{
  int	i;

  for (i=0; i<3; i++) {
    buf[i] = 0;
  }
}


void
check ()
{
  if (buf[0] != 1  ||  buf[1] != 2  ||  buf[2] != 3) {
    errors += 1;
  }
}


void
func_sections()
{
  #pragma omp sections
  {
    #pragma omp section
    buf[0] += 1;

    #pragma omp section
    {
      buf[2] += 3;
    }

    #pragma omp section
    buf[1] += 2;
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    #pragma omp sections
    {
      #pragma omp section
      buf[0] += 1;

      #pragma omp section
      buf[1] += 2;

      #pragma omp section
      {
	buf[2] += 3;
      }
    }
  }
  check ();


  clear ();
  #pragma omp parallel
  {
    func_sections ();
  }
  check ();


  clear ();
  func_sections ();
  check ();


  if (errors == 0) {
    printf ("sections 001 : SUCCESS\n");
    return 0;
  } else {
    printf ("sections 001 : FAILED\n");
    return 1;
  }
}
