static char rcsid[] = "$Id: sctn006.c,v 1.7 2000/10/13 19:27:16 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* sections 006:
 * nowait ꤷưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds;
int	buf[3];


int	errors = 0;


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush(cnt)
  }
}


void
clear ()
{
  int	i;

  for (i=0; i<3; i++) {
    buf[i] = -1;
  }
}


void
func_sections()
{
  int	id = omp_get_thread_num ();


  #pragma omp barrier

  #pragma omp sections nowait
  {
    #pragma omp section
    {
      buf[0] = omp_get_thread_num ();
      barrier (2);
    }

    #pragma omp section
    {
      barrier (2);
      waittime(1);
      buf[1] = omp_get_thread_num ();
    }
  }

  if (buf[1] != -1  &&  buf[1] != id) {
    #pragma omp critical
    errors += 1;
  }
}


main ()
{


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();
    #pragma omp barrier

    #pragma omp sections nowait
    {
      #pragma omp section
      {
	buf[0] = omp_get_thread_num ();
	barrier (2);
      }

      #pragma omp section
      {
	barrier (2);
	waittime(1);
	buf[1] = omp_get_thread_num ();
      }
    }

    if (buf[1] != -1  &&  buf[1] != id) {
      #pragma omp critical
      errors += 1;
    }
  }


  clear ();
  #pragma omp parallel
  {
    func_sections ();
  }


  if (errors == 0) {
    printf ("sections 006 : SUCCESS\n");
    return 0;
  } else {
    printf ("sections 006 : FAILED\n");
    return 1;
  }
}
