static char rcsid[] = "$Id: sngl001.c,v 1.4 2000/07/30 13:10:16 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* single 001:
 * ñ single directive ꤷ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


void
incr (int *ptr)
{
  #pragma omp single
  *ptr += 1;
}


main ()
{
  int	thds, buf[4];

  int	errors = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  memset (buf, 0, sizeof (buf));
  #pragma omp parallel
  {
    #pragma omp single
    buf[0] += 1;

    #pragma omp single
    {
      buf[1] += 1;
    }

    incr (&buf[2]);
  }

  incr(&buf[3]);

  if (buf[0] != 1  ||  buf[1] != 1 || buf[2] != 1 || buf[3] != 1) {
    errors += 1;
  }

  if (errors == 0) {
    printf ("single 001 : SUCCESS\n");
    return 0;
  } else {
    printf ("single 001 : FAILED\n");
    return 1;
  }
}
