static char rcsid[] = "$Id: sngl002.c,v 1.7 2000/10/13 19:27:18 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* single 002:
 * single directive νλΥХꥢưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	thds, id, flag;

int	errors = 0;


void
func_single ()
{
  #pragma omp barrier

  #pragma omp single
  {
    id = omp_get_thread_num ();
    #pragma omp flush
    waittime (1);
    flag = 1;
  }

  if (id != omp_get_thread_num ()) {
    if (flag == 0) {
      #pragma omp critical
      errors += 1;
    }
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  id = -1;
  flag = 0;
  #pragma omp parallel
  {
    #pragma omp barrier

    #pragma omp single
    {
      id = omp_get_thread_num ();
      #pragma omp flush
      waittime (1);
      flag = 1;
    }
    if (id != omp_get_thread_num ()) {
      if (flag == 0) {
	#pragma omp critical
	errors += 1;
      }
    }

  }


  id = -1;
  flag = 0;
  #pragma omp parallel
  {
    func_single ();
  }


  if (errors == 0) {
    printf ("single 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("single 002 : FAILED\n");
    return 1;
  }
}
