static char rcsid[] = "$Id: sngl004.c,v 1.4 2000/07/30 13:10:16 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* single 004:
 * data attribute ꤵ줿
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int	errors = 0;

int	thds;
int	prvt, fprvt;


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  fprvt = -1;
  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();

    #pragma omp barrier

    prvt = id;
    #pragma omp single private(prvt)
    {
      prvt = id;
      waittime(1);
      if (prvt != id) {
	errors += 1;
      }
    }
    prvt = id;
      
    #pragma omp single firstprivate(fprvt)
    {
      if (fprvt != -1) {
	errors += 1;
      }
      fprvt = id;
      waittime(1);
      if (fprvt != id) {
	errors += 1;
      }
    }
    fprvt = id;

  }


  if (errors == 0) {
    printf ("single 004 : SUCCESS\n");
    return 0;
  } else {
    printf ("single 004 : FAILED\n");
    return 1;
  }
}
