static char rcsid[] = "$Id: envparam.c,v 1.4 2000/07/30 13:10:19 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include "omniConfig.h"
#include <stdlib.h>
#include <string.h>
#include <omp.h>
#include "omni.h"


void
check_thread_num ()
{
  printf ("number of threads is %d\n", omp_get_max_threads ());
}


void
check_dynamic ()
{
  if (omp_get_dynamic () == 0) {
    printf ("dynamic schedule is disable\n");
  } else {
    printf ("dynamic schedule is enable\n");
  }
}


void
check_nested ()
{
  if (omp_get_nested () == 0) {
    printf ("nested parallelism is disable\n");
  } else {
    printf ("nested parallelism is enable\n");
  }
}


usage (name)
     char *name;
{
  char *cmd;

  cmd = strrchr (name, '/');
  if (cmd == NULL) {
    cmd = name;
  } else {
    cmd += 1;
  }

  printf ("%s : [options]\n", cmd);
  printf ("--------------\n");
  printf ("-t : print number of threads\n");
  printf ("-d : print dynamic schedule is enable/disable\n");
  printf ("-n : print nested parallelism is enable/disable\n");
  printf ("-h : this message.\n");

  exit (0);
}


main (argc, argv)
     int	argc;
     char	*argv[];
{
  extern char	*optarg;
  extern int	optind;

  int	c;

  while ((c = getopt (argc, argv, "tdnh")) != EOF) {
    switch (c) {
    case 't':
      check_thread_num ();
      break;
    case 'd':
      check_dynamic ();
      break;
    case 'n':
      check_nested ();
      break;
    case 'h':
    default:
      usage(argv[0]);
      break;
    }
  }

  return 0;
}
