static char rcsid[] = "$Id: afntyschd015.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 015
 * 󥵥üξˡcyclic ˥2ꤷ
 * affinity scheduling ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE		(2*3*4 + 1)
#define CHUNKSZ		(2)


int array1[SIZE][SIZE][SIZE];
int array2[SIZE][SIZE][SIZE];
int array3[SIZE][SIZE][SIZE];

#pragma omni mapping(array1[cyclic(2)][*][*])
#pragma omni mapping(array2[*][cyclic(2)][*])
#pragma omni mapping(array3[*][*][cyclic(2)])

int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end, int stride, int offset)
{
  int chunk, i, v, next;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      v = (i/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  for (p=0; p<SIZE; p++) {
    for (s=1; s<SIZE; s++) {
      memset (array1, 0, sizeof(array1));
      #pragma omp parallel for schedule(affinity, array1[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array1[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array1, CHUNKSZ, SIZE, p, SIZE, s, SIZE*SIZE);

      memset (array1, 0, sizeof(array1));
      #pragma omp parallel for schedule(affinity, array1[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array1[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array1, CHUNKSZ, SIZE, 0, SIZE-p, s, SIZE*SIZE);

      memset (array2, 0, sizeof(array2));
      #pragma omp parallel for schedule(affinity, array2[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array2[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array2, CHUNKSZ, SIZE, p, SIZE, s, SIZE);

      memset (array2, 0, sizeof(array2));
      #pragma omp parallel for schedule(affinity, array2[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array2[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array2, CHUNKSZ, SIZE, 0, SIZE-p, s, SIZE);

      memset (array3, 0, sizeof(array3));
      #pragma omp parallel for schedule(affinity, array3[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array3[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array3, CHUNKSZ, SIZE, p, SIZE, s, 1);

      memset (array3, 0, sizeof(array3));
      #pragma omp parallel for schedule(affinity, array3[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array3[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array3, CHUNKSZ, SIZE, 0, SIZE-p, s, 1);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 015 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 015 : FAILED\n");
    return 1;
  }
}


#endif
