static char rcsid[] = "$Id: afntyschd020.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 020
 * ۤʤ󥵥֤ǡexpr mapping ꤷ affinity scheduling ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define BSIZE		(2*3*4)
#define SIZEBIG		(2*3*4*2)
#define SIZESMALL	(2*3*4/2)

int base[BSIZE];
int array1[SIZEBIG];
int array2[SIZESMALL];
int array3[SIZEBIG][BSIZE];
int array4[SIZESMALL][BSIZE];
int array5[BSIZE][SIZEBIG];
int array6[BSIZE][SIZESMALL];

#pragma omni mapping(base[block])
#pragma omni mapping(array1:base)
#pragma omni mapping(array2:base)
#pragma omni mapping(array3[i][*]:base[i])
#pragma omni mapping(array4[i][*]:base[i])
#pragma omni mapping(array5[*][i]:base[i])
#pragma omni mapping(array6[*][i]:base[i])

int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end, int stride, int offset)
{
  int chunk, i, v, next;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      v = (i/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  chunksz = (BSIZE + thds - 1) / thds;


  for (p=0; p<SIZEBIG; p++) {
    for (s=1; s<SIZEBIG; s++) {
      memset (array1, 0, sizeof(array1));
      #pragma omp parallel for schedule(affinity, array1[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array1[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array1, chunksz, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array1, 0, sizeof(array1));
      #pragma omp parallel for schedule(affinity, array1[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array1[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array1, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array3, 0, sizeof(array3));
      #pragma omp parallel for schedule(affinity, array3[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array3[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array3, chunksz, SIZEBIG, p, SIZEBIG, s, BSIZE);

      memset (array3, 0, sizeof(array3));
      #pragma omp parallel for schedule(affinity, array3[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array3[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array3, chunksz, SIZEBIG, 0, SIZEBIG-p, s, BSIZE);

      memset (array5, 0, sizeof(array5));
      #pragma omp parallel for schedule(affinity, array5[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array5[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array5, chunksz, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array5, 0, sizeof(array5));
      #pragma omp parallel for schedule(affinity, array5[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array5[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array5, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1);
    }
  }

  for (p=0; p<SIZESMALL; p++) {
    for (s=1; s<SIZESMALL; s++) {
      memset (array2, 0, sizeof(array2));
      #pragma omp parallel for schedule(affinity, array2[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array2[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array2, chunksz, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array2, 0, sizeof(array2));
      #pragma omp parallel for schedule(affinity, array2[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array2[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array2, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array4, 0, sizeof(array4));
      #pragma omp parallel for schedule(affinity, array4[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array4[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array4, chunksz, SIZESMALL, p, SIZESMALL, s, BSIZE);

      memset (array4, 0, sizeof(array4));
      #pragma omp parallel for schedule(affinity, array4[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array4[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array4, chunksz, SIZESMALL, 0, SIZESMALL-p, s, BSIZE);

      memset (array6, 0, sizeof(array6));
      #pragma omp parallel for schedule(affinity, array6[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array6[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array6, chunksz, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array6, 0, sizeof(array6));
      #pragma omp parallel for schedule(affinity, array6[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array6[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array6, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 020 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 020 : FAILED\n");
    return 1;
  }
}


#endif
