static char rcsid[] = "$Id: afntyschd026.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 026
 * ۤʤ󥵥֤ǡexpr mapping ꤷ affinity scheduling ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define BSIZE		(2*3*4)
#define SIZEBIG		(2*3*4*2 + 1)
#define SIZESMALL	(2*3*4/2 + 1)

#define CHUNK1	1
#define CHUNK2	2
#define CHUNK3	100

int base1[BSIZE];
int base2[BSIZE];
int base3[BSIZE];
int base4[BSIZE];

#pragma omni mapping(base1[cyclic])
#pragma omni mapping(base2[cyclic(1)])
#pragma omni mapping(base3[cyclic(2)])
#pragma omni mapping(base4[cyclic(100)])

int array11[SIZEBIG];
int array12[SIZEBIG];
int array13[SIZEBIG];
int array14[SIZEBIG];

int array21[SIZESMALL];
int array22[SIZESMALL];
int array23[SIZESMALL];
int array24[SIZESMALL];

int array31[SIZEBIG][BSIZE];
int array32[SIZEBIG][BSIZE];
int array33[SIZEBIG][BSIZE];
int array34[SIZEBIG][BSIZE];

int array41[SIZESMALL][BSIZE];
int array42[SIZESMALL][BSIZE];
int array43[SIZESMALL][BSIZE];
int array44[SIZESMALL][BSIZE];

int array51[BSIZE][SIZEBIG];
int array52[BSIZE][SIZEBIG];
int array53[BSIZE][SIZEBIG];
int array54[BSIZE][SIZEBIG];

int array61[BSIZE][SIZESMALL];
int array62[BSIZE][SIZESMALL];
int array63[BSIZE][SIZESMALL];
int array64[BSIZE][SIZESMALL];

#pragma omni mapping(array11:base1)
#pragma omni mapping(array12:base2)
#pragma omni mapping(array13:base3)
#pragma omni mapping(array14:base4)

#pragma omni mapping(array21:base1)
#pragma omni mapping(array22:base2)
#pragma omni mapping(array23:base3)
#pragma omni mapping(array24:base4)

#pragma omni mapping(array31[i][*]:base1[i])
#pragma omni mapping(array32[i][*]:base2[i])
#pragma omni mapping(array33[i][*]:base3[i])
#pragma omni mapping(array34[i][*]:base4[i])

#pragma omni mapping(array41[i][*]:base1[i])
#pragma omni mapping(array42[i][*]:base2[i])
#pragma omni mapping(array43[i][*]:base3[i])
#pragma omni mapping(array44[i][*]:base4[i])

#pragma omni mapping(array51[*][i]:base1[i])
#pragma omni mapping(array52[*][i]:base2[i])
#pragma omni mapping(array53[*][i]:base3[i])
#pragma omni mapping(array54[*][i]:base4[i])

#pragma omni mapping(array61[*][i]:base1[i])
#pragma omni mapping(array62[*][i]:base2[i])
#pragma omni mapping(array63[*][i]:base3[i])
#pragma omni mapping(array64[*][i]:base4[i])

int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end, int stride, int offset)
{
  int chunk, i, v, next;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      v = (i/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }


  for (p=0; p<SIZEBIG; p++) {
    for (s=1; s<SIZEBIG; s++) {
      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, CHUNK3, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, CHUNK3, SIZEBIG, 0, SIZEBIG-p, s, 1);


      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array31[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array31[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array32[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array32[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array33[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array33[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array34[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, CHUNK3, SIZEBIG, p, SIZEBIG, s, BSIZE);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array34[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, CHUNK3, SIZEBIG, 0, SIZEBIG-p, s, BSIZE);


      memset (array51, 0, sizeof(array51));
      #pragma omp parallel for schedule(affinity, array51[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array51[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array51, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array51, 0, sizeof(array51));
      #pragma omp parallel for schedule(affinity, array51[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array51[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array51, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array52, 0, sizeof(array52));
      #pragma omp parallel for schedule(affinity, array52[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array52[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array52, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array52, 0, sizeof(array52));
      #pragma omp parallel for schedule(affinity, array52[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array52[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array52, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array53, 0, sizeof(array53));
      #pragma omp parallel for schedule(affinity, array53[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array53[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array53, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array53, 0, sizeof(array53));
      #pragma omp parallel for schedule(affinity, array53[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array53[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array53, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1);

      memset (array54, 0, sizeof(array54));
      #pragma omp parallel for schedule(affinity, array54[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array54[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array54, CHUNK3, SIZEBIG, p, SIZEBIG, s, 1);

      memset (array54, 0, sizeof(array54));
      #pragma omp parallel for schedule(affinity, array54[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array54[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array54, CHUNK3, SIZEBIG, 0, SIZEBIG-p, s, 1);
    }
  }

  for (p=0; p<SIZESMALL; p++) {
    for (s=1; s<SIZESMALL; s++) {
      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array21[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array21[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array22[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array22[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array23[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array23[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array24[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, CHUNK3, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array24[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, CHUNK3, SIZESMALL, 0, SIZESMALL-p, s, 1);


      memset (array41, 0, sizeof(array41));
      #pragma omp parallel for schedule(affinity, array41[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array41[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array41, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE);

      memset (array41, 0, sizeof(array41));
      #pragma omp parallel for schedule(affinity, array41[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array41[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array41, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE);

      memset (array42, 0, sizeof(array42));
      #pragma omp parallel for schedule(affinity, array42[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array42[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array42, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE);

      memset (array42, 0, sizeof(array42));
      #pragma omp parallel for schedule(affinity, array42[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array42[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array42, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE);

      memset (array43, 0, sizeof(array43));
      #pragma omp parallel for schedule(affinity, array43[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array43[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array43, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE);

      memset (array43, 0, sizeof(array43));
      #pragma omp parallel for schedule(affinity, array43[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array43[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array43, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE);

      memset (array44, 0, sizeof(array44));
      #pragma omp parallel for schedule(affinity, array44[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array44[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array44, CHUNK3, SIZESMALL, p, SIZESMALL, s, BSIZE);

      memset (array44, 0, sizeof(array44));
      #pragma omp parallel for schedule(affinity, array44[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array44[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array44, CHUNK3, SIZESMALL, 0, SIZESMALL-p, s, BSIZE);


      memset (array61, 0, sizeof(array61));
      #pragma omp parallel for schedule(affinity, array61[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array61[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array61, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array61, 0, sizeof(array61));
      #pragma omp parallel for schedule(affinity, array61[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array61[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array61, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array62, 0, sizeof(array62));
      #pragma omp parallel for schedule(affinity, array62[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array62[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array62, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array62, 0, sizeof(array62));
      #pragma omp parallel for schedule(affinity, array62[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array62[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array62, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array63, 0, sizeof(array63));
      #pragma omp parallel for schedule(affinity, array63[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array63[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array63, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array63, 0, sizeof(array63));
      #pragma omp parallel for schedule(affinity, array63[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array63[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array63, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1);

      memset (array64, 0, sizeof(array64));
      #pragma omp parallel for schedule(affinity, array64[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array64[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array64, CHUNK3, SIZESMALL, p, SIZESMALL, s, 1);

      memset (array64, 0, sizeof(array64));
      #pragma omp parallel for schedule(affinity, array64[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array64[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array64, CHUNK3, SIZESMALL, 0, SIZESMALL-p, s, 1);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 026 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 026 : FAILED\n");
    return 1;
  }
}


#endif
