static char rcsid[] = "$Id: afntyschd029.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 029
 * offset ꤷơۤʤ뼡֤ǡexpr mapping 򤷤ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE	(2*3*4)

#define OFFSET1	(1)
#define OFFSET2	(2)
#define OFFSET3	(100)
#define OFFSET4	(-1)
#define OFFSET5	(-2)
#define OFFSET6	(-100)


int base[SIZE][SIZE][SIZE];

#pragma omni mapping (base[*][block][*])


int array11[SIZE][SIZE][SIZE];
int array12[SIZE][SIZE][SIZE];
int array13[SIZE][SIZE][SIZE];
int array14[SIZE][SIZE][SIZE];
int array15[SIZE][SIZE][SIZE];
int array16[SIZE][SIZE][SIZE];
int array21[SIZE][SIZE][SIZE];
int array22[SIZE][SIZE][SIZE];
int array23[SIZE][SIZE][SIZE];
int array24[SIZE][SIZE][SIZE];
int array25[SIZE][SIZE][SIZE];
int array26[SIZE][SIZE][SIZE];
int array31[SIZE][SIZE][SIZE];
int array32[SIZE][SIZE][SIZE];
int array33[SIZE][SIZE][SIZE];
int array34[SIZE][SIZE][SIZE];
int array35[SIZE][SIZE][SIZE];
int array36[SIZE][SIZE][SIZE];

#pragma omni mapping (array11[i][*][*]:base[*][i+1][*])
#pragma omni mapping (array12[i][*][*]:base[*][i+2][*])
#pragma omni mapping (array13[i][*][*]:base[*][i+100][*])
#pragma omni mapping (array14[i][*][*]:base[*][i-1][*])
#pragma omni mapping (array15[i][*][*]:base[*][i-2][*])
#pragma omni mapping (array16[i][*][*]:base[*][i-100][*])

#pragma omni mapping (array21[*][i][*]:base[*][i+1][*])
#pragma omni mapping (array22[*][i][*]:base[*][i+2][*])
#pragma omni mapping (array23[*][i][*]:base[*][i+100][*])
#pragma omni mapping (array24[*][i][*]:base[*][i-1][*])
#pragma omni mapping (array25[*][i][*]:base[*][i-2][*])
#pragma omni mapping (array26[*][i][*]:base[*][i-100][*])

#pragma omni mapping (array31[*][*][i]:base[*][i+1][*])
#pragma omni mapping (array32[*][*][i]:base[*][i+2][*])
#pragma omni mapping (array33[*][*][i]:base[*][i+100][*])
#pragma omni mapping (array34[*][*][i]:base[*][i-1][*])
#pragma omni mapping (array35[*][*][i]:base[*][i-2][*])
#pragma omni mapping (array36[*][*][i]:base[*][i-100][*])




int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  chunksz = (SIZE + thds - 1) / thds;

  for (p=0; p<SIZE; p++) {
    for (s=1; s<SIZE; s++) {
      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET1);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET1);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array12[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET2);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array12[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET2);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array13[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET3);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array13[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET3);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array14[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET4);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array14[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET4);

      memset (array15, 0, sizeof(array15));
      #pragma omp parallel for schedule(affinity, array15[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array15[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array15, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET5);

      memset (array15, 0, sizeof(array15));
      #pragma omp parallel for schedule(affinity, array15[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array15[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array15, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET5);

      memset (array16, 0, sizeof(array16));
      #pragma omp parallel for schedule(affinity, array16[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array16[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array16, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET6);

      memset (array16, 0, sizeof(array16));
      #pragma omp parallel for schedule(affinity, array16[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array16[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array16, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET6);


      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array22[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array22[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array23[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET3);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array23[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET3);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array24[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET4);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array24[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET4);

      memset (array25, 0, sizeof(array25));
      #pragma omp parallel for schedule(affinity, array25[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array25[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array25, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET5);

      memset (array25, 0, sizeof(array25));
      #pragma omp parallel for schedule(affinity, array25[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array25[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array25, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET5);

      memset (array26, 0, sizeof(array26));
      #pragma omp parallel for schedule(affinity, array26[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array26[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array26, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET6);

      memset (array26, 0, sizeof(array26));
      #pragma omp parallel for schedule(affinity, array26[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array26[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array26, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET6);


      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array32[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, chunksz, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array32[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array33[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, chunksz, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array33[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array34[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, chunksz, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array34[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array35, 0, sizeof(array35));
      #pragma omp parallel for schedule(affinity, array35[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array35[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array35, chunksz, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array35, 0, sizeof(array35));
      #pragma omp parallel for schedule(affinity, array35[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array35[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array35, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array36, 0, sizeof(array36));
      #pragma omp parallel for schedule(affinity, array36[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array36[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array36, chunksz, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array36, 0, sizeof(array36));
      #pragma omp parallel for schedule(affinity, array36[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array36[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array36, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET6);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 029 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 029 : FAILED\n");
    return 1;
  }
}


#endif
