static char rcsid[] = "$Id: afntyschd033.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 033
 * offset ꤷơüǡۤʤ륵
 *  expr mapping ˻ꤷưǧ
 * base(affinity 022)
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"

#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE		(2*3*4 + 1)
#define SIZEBIG		(2*3*4*2)
#define SIZESMALL	(2*3*4/2)

#define OFFSET1	(1)
#define OFFSET2	(2)
#define OFFSET3	(100)
#define OFFSET4	(-1)
#define OFFSET5	(-2)
#define OFFSET6	(-100)


int base[SIZE];

#pragma omni mapping (base[block])


int array11[SIZEBIG];
int array12[SIZEBIG];
int array13[SIZEBIG];
int array14[SIZEBIG];
int array15[SIZEBIG];
int array16[SIZEBIG];
int array21[SIZEBIG][SIZE];
int array22[SIZEBIG][SIZE];
int array23[SIZEBIG][SIZE];
int array24[SIZEBIG][SIZE];
int array25[SIZEBIG][SIZE];
int array26[SIZEBIG][SIZE];
int array31[SIZE][SIZEBIG];
int array32[SIZE][SIZEBIG];
int array33[SIZE][SIZEBIG];
int array34[SIZE][SIZEBIG];
int array35[SIZE][SIZEBIG];
int array36[SIZE][SIZEBIG];

#pragma omni mapping (array11[i]:base[i+1])
#pragma omni mapping (array12[i]:base[i+2])
#pragma omni mapping (array13[i]:base[i+100])
#pragma omni mapping (array14[i]:base[i-1])
#pragma omni mapping (array15[i]:base[i-2])
#pragma omni mapping (array16[i]:base[i-100])

#pragma omni mapping (array21[i][*]:base[i+1])
#pragma omni mapping (array22[i][*]:base[i+2])
#pragma omni mapping (array23[i][*]:base[i+100])
#pragma omni mapping (array24[i][*]:base[i-1])
#pragma omni mapping (array25[i][*]:base[i-2])
#pragma omni mapping (array26[i][*]:base[i-100])

#pragma omni mapping (array31[*][i]:base[i+1])
#pragma omni mapping (array32[*][i]:base[i+2])
#pragma omni mapping (array33[*][i]:base[i+100])
#pragma omni mapping (array34[*][i]:base[i-1])
#pragma omni mapping (array35[*][i]:base[i-2])
#pragma omni mapping (array36[*][i]:base[i-100])


int sarray11[SIZESMALL];
int sarray12[SIZESMALL];
int sarray13[SIZESMALL];
int sarray14[SIZESMALL];
int sarray15[SIZESMALL];
int sarray16[SIZESMALL];
int sarray21[SIZESMALL][SIZE];
int sarray22[SIZESMALL][SIZE];
int sarray23[SIZESMALL][SIZE];
int sarray24[SIZESMALL][SIZE];
int sarray25[SIZESMALL][SIZE];
int sarray26[SIZESMALL][SIZE];
int sarray31[SIZE][SIZESMALL];
int sarray32[SIZE][SIZESMALL];
int sarray33[SIZE][SIZESMALL];
int sarray34[SIZE][SIZESMALL];
int sarray35[SIZE][SIZESMALL];
int sarray36[SIZE][SIZESMALL];

#pragma omni mapping (sarray11[i]:base[i+1])
#pragma omni mapping (sarray12[i]:base[i+2])
#pragma omni mapping (sarray13[i]:base[i+100])
#pragma omni mapping (sarray14[i]:base[i-1])
#pragma omni mapping (sarray15[i]:base[i-2])
#pragma omni mapping (sarray16[i]:base[i-100])

#pragma omni mapping (sarray21[i][*]:base[i+1])
#pragma omni mapping (sarray22[i][*]:base[i+2])
#pragma omni mapping (sarray23[i][*]:base[i+100])
#pragma omni mapping (sarray24[i][*]:base[i-1])
#pragma omni mapping (sarray25[i][*]:base[i-2])
#pragma omni mapping (sarray26[i][*]:base[i-100])

#pragma omni mapping (sarray31[*][i]:base[i+1])
#pragma omni mapping (sarray32[*][i]:base[i+2])
#pragma omni mapping (sarray33[*][i]:base[i+100])
#pragma omni mapping (sarray34[*][i]:base[i-1])
#pragma omni mapping (sarray35[*][i]:base[i-2])
#pragma omni mapping (sarray36[*][i]:base[i-100])


int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  chunksz = (SIZE + thds - 1) / thds;

  for (p=0; p<SIZEBIG; p++) {
    for (s=1; s<SIZEBIG; s++) {
      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array13, 0, sizeof(array13));
      #pragma omp parallel for schedule(affinity, array13[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array13, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array14, 0, sizeof(array14));
      #pragma omp parallel for schedule(affinity, array14[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array14, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array15, 0, sizeof(array15));
      #pragma omp parallel for schedule(affinity, array15[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array15[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array15, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array15, 0, sizeof(array15));
      #pragma omp parallel for schedule(affinity, array15[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array15[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array15, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array16, 0, sizeof(array16));
      #pragma omp parallel for schedule(affinity, array16[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array16[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array16, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array16, 0, sizeof(array16));
      #pragma omp parallel for schedule(affinity, array16[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array16[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array16, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array21[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET1);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array21[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET1);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array22[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET2);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array22[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET2);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array23[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET3);

      memset (array23, 0, sizeof(array23));
      #pragma omp parallel for schedule(affinity, array23[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array23[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array23, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET3);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array24[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET4);

      memset (array24, 0, sizeof(array24));
      #pragma omp parallel for schedule(affinity, array24[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array24[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array24, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET4);

      memset (array25, 0, sizeof(array25));
      #pragma omp parallel for schedule(affinity, array25[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array25[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array25, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET5);

      memset (array25, 0, sizeof(array25));
      #pragma omp parallel for schedule(affinity, array25[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array25[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array25, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET5);

      memset (array26, 0, sizeof(array26));
      #pragma omp parallel for schedule(affinity, array26[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array26[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array26, chunksz, SIZEBIG, p, SIZEBIG, s, SIZE, OFFSET6);

      memset (array26, 0, sizeof(array26));
      #pragma omp parallel for schedule(affinity, array26[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array26[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array26, chunksz, SIZEBIG, 0, SIZEBIG-p, s, SIZE, OFFSET6);


      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array31[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array31[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array32[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array32[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array33[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array33, 0, sizeof(array33));
      #pragma omp parallel for schedule(affinity, array33[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array33[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array33, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array34[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array34, 0, sizeof(array34));
      #pragma omp parallel for schedule(affinity, array34[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array34[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array34, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array35, 0, sizeof(array35));
      #pragma omp parallel for schedule(affinity, array35[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array35[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array35, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array35, 0, sizeof(array35));
      #pragma omp parallel for schedule(affinity, array35[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array35[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array35, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array36, 0, sizeof(array36));
      #pragma omp parallel for schedule(affinity, array36[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array36[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array36, chunksz, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array36, 0, sizeof(array36));
      #pragma omp parallel for schedule(affinity, array36[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array36[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array36, chunksz, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);
    }
  }


  for (p=0; p<SIZESMALL; p++) {
    for (s=1; s<SIZESMALL; s++) {
      memset (sarray11, 0, sizeof(sarray11));
      #pragma omp parallel for schedule(affinity, sarray11[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray11, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (sarray11, 0, sizeof(sarray11));
      #pragma omp parallel for schedule(affinity, sarray11[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray11[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray11, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (sarray12, 0, sizeof(sarray12));
      #pragma omp parallel for schedule(affinity, sarray12[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray12, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (sarray12, 0, sizeof(sarray12));
      #pragma omp parallel for schedule(affinity, sarray12[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray12[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray12, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (sarray13, 0, sizeof(sarray13));
      #pragma omp parallel for schedule(affinity, sarray13[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray13, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (sarray13, 0, sizeof(sarray13));
      #pragma omp parallel for schedule(affinity, sarray13[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray13[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray13, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (sarray14, 0, sizeof(sarray14));
      #pragma omp parallel for schedule(affinity, sarray14[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray14, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (sarray14, 0, sizeof(sarray14));
      #pragma omp parallel for schedule(affinity, sarray14[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray14[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray14, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (sarray15, 0, sizeof(sarray15));
      #pragma omp parallel for schedule(affinity, sarray15[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray15[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray15, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (sarray15, 0, sizeof(sarray15));
      #pragma omp parallel for schedule(affinity, sarray15[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray15[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray15, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (sarray16, 0, sizeof(sarray16));
      #pragma omp parallel for schedule(affinity, sarray16[i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray16[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray16, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (sarray16, 0, sizeof(sarray16));
      #pragma omp parallel for schedule(affinity, sarray16[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray16[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray16, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (sarray21, 0, sizeof(sarray21));
      #pragma omp parallel for schedule(affinity, sarray21[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray21[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray21, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET1);

      memset (sarray21, 0, sizeof(sarray21));
      #pragma omp parallel for schedule(affinity, sarray21[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray21[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray21, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET1);

      memset (sarray22, 0, sizeof(sarray22));
      #pragma omp parallel for schedule(affinity, sarray22[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray22[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray22, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET2);

      memset (sarray22, 0, sizeof(sarray22));
      #pragma omp parallel for schedule(affinity, sarray22[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray22[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray22, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET2);

      memset (sarray23, 0, sizeof(sarray23));
      #pragma omp parallel for schedule(affinity, sarray23[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray23[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray23, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET3);

      memset (sarray23, 0, sizeof(sarray23));
      #pragma omp parallel for schedule(affinity, sarray23[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray23[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray23, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET3);

      memset (sarray24, 0, sizeof(sarray24));
      #pragma omp parallel for schedule(affinity, sarray24[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray24[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray24, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET4);

      memset (sarray24, 0, sizeof(sarray24));
      #pragma omp parallel for schedule(affinity, sarray24[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray24[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray24, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET4);

      memset (sarray25, 0, sizeof(sarray25));
      #pragma omp parallel for schedule(affinity, sarray25[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray25[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray25, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET5);

      memset (sarray25, 0, sizeof(sarray25));
      #pragma omp parallel for schedule(affinity, sarray25[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray25[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray25, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET5);

      memset (sarray26, 0, sizeof(sarray26));
      #pragma omp parallel for schedule(affinity, sarray26[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray26[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray26, chunksz, SIZESMALL, p, SIZESMALL, s, SIZE, OFFSET6);

      memset (sarray26, 0, sizeof(sarray26));
      #pragma omp parallel for schedule(affinity, sarray26[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray26[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray26, chunksz, SIZESMALL, 0, SIZESMALL-p, s, SIZE, OFFSET6);


      memset (sarray31, 0, sizeof(sarray31));
      #pragma omp parallel for schedule(affinity, sarray31[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray31[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray31, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (sarray31, 0, sizeof(sarray31));
      #pragma omp parallel for schedule(affinity, sarray31[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray31[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray31, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (sarray32, 0, sizeof(sarray32));
      #pragma omp parallel for schedule(affinity, sarray32[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray32[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray32, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (sarray32, 0, sizeof(sarray32));
      #pragma omp parallel for schedule(affinity, sarray32[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray32[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray32, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (sarray33, 0, sizeof(sarray33));
      #pragma omp parallel for schedule(affinity, sarray33[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray33[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray33, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (sarray33, 0, sizeof(sarray33));
      #pragma omp parallel for schedule(affinity, sarray33[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray33[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray33, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (sarray34, 0, sizeof(sarray34));
      #pragma omp parallel for schedule(affinity, sarray34[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray34[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray34, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (sarray34, 0, sizeof(sarray34));
      #pragma omp parallel for schedule(affinity, sarray34[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray34[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray34, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (sarray35, 0, sizeof(sarray35));
      #pragma omp parallel for schedule(affinity, sarray35[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray35[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray35, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (sarray35, 0, sizeof(sarray35));
      #pragma omp parallel for schedule(affinity, sarray35[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray35[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray35, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (sarray36, 0, sizeof(sarray36));
      #pragma omp parallel for schedule(affinity, sarray36[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	sarray36[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray36, chunksz, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (sarray36, 0, sizeof(sarray36));
      #pragma omp parallel for schedule(affinity, sarray36[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	sarray36[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)sarray36, chunksz, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 033 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 033 : FAILED\n");
    return 1;
  }
}


#endif
